/*
 * Decompiled with CFR 0.152.
 */
package jab.radar;

import jab.module.Module;
import jab.module.Radar;
import robocode.Event;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class WideLock
extends Radar {
    private int timeSinceLastScan = 10;
    private double enemyAbsoluteBearing;

    public WideLock(Module bot) {
        super(bot);
    }

    public void scan() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.NEGATIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.bot.getRadarHeadingRadians() - this.enemyAbsoluteBearing));
            radarOffset += Math.signum(radarOffset) * 0.2;
        }
        this.bot.setTurnRadarLeftRadians(radarOffset);
    }

    public void listen(Event e) {
        if (e instanceof ScannedRobotEvent && !this.bot.isTeammate(((ScannedRobotEvent)e).getName())) {
            this.enemyAbsoluteBearing = this.bot.getHeadingRadians() + ((ScannedRobotEvent)e).getBearingRadians();
            this.timeSinceLastScan = 0;
        }
    }
}

