/*
 * Decompiled with CFR 0.152.
 */
package rjw.pluggablerobot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;

public class Canvas {
    private Graphics2D _g;
    private double _width;
    private double _height;
    private Point2D.Double _center;

    Canvas(AdvancedRobot bot) {
        this._g = bot.getGraphics();
        this._width = bot.getBattleFieldWidth();
        this._height = bot.getBattleFieldHeight();
        this._center = new Point2D.Double(this._width / 2.0, this._height / 2.0);
    }

    public void clearRect(double x, double y, double width, double height) {
        this._g.clearRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void clip(Shape shape) {
        this._g.clip(shape);
    }

    public void clipRect(double x, double y, double width, double height) {
        this._g.clipRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void copyArea(double x, double y, double width, double height, double dx, double dy) {
        this._g.copyArea(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height), Canvas.i(dx), Canvas.i(dy));
    }

    public void draw(Shape shape) {
        this._g.draw(shape);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this._g.drawArc(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height), Canvas.i(startAngle), Canvas.i(arcAngle));
    }

    public void drawCircle(double x, double y, double r) {
        int d = Canvas.i(r * 2.0);
        this._g.drawOval(Canvas.i(x - r), Canvas.i(y - r), d, d);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this._g.drawLine(Canvas.i(x1), Canvas.i(y1), Canvas.i(x2), Canvas.i(y2));
    }

    public void drawOval(double x, double y, double width, double height) {
        this._g.drawOval(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void drawRect(double x, double y, double width, double height) {
        this._g.drawRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this._g.drawRoundRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height), Canvas.i(arcWidth), Canvas.i(arcHeight));
    }

    public void drawString(String str, double x, double y) {
        this._g.drawString(str, (float)x, (float)y);
    }

    public void drawString(String str, double x, double y, Align align) {
        align.drawString(this, str, x, y);
    }

    public void fill(Shape shape) {
        this._g.fill(shape);
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this._g.fillArc(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height), Canvas.i(startAngle), Canvas.i(arcAngle));
    }

    public void fillCircle(double x, double y, double r) {
        int d = Canvas.i(r * 2.0);
        this._g.fillOval(Canvas.i(x - r), Canvas.i(y - r), d, d);
    }

    public void fillOval(double x, double y, double width, double height) {
        this._g.fillOval(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void fillRect(double x, double y, double width, double height) {
        this._g.fillRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this._g.fillRoundRect(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height), Canvas.i(arcWidth), Canvas.i(arcHeight));
    }

    public Color getBackground() {
        return this._g.getBackground();
    }

    public Point2D.Double getCenter() {
        return this._center;
    }

    public Shape getClip() {
        return this._g.getClip();
    }

    public Rectangle getClipBounds() {
        return this._g.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle r) {
        return this._g.getClipBounds(r);
    }

    public Color getColor() {
        return this._g.getColor();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this._g.getDeviceConfiguration();
    }

    public Font getFont() {
        return this._g.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this._g.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this._g.getFontMetrics(f);
    }

    public FontRenderContext getFontRenderContext() {
        return this._g.getFontRenderContext();
    }

    public Graphics2D getGraphics() {
        return this._g;
    }

    public double getHeight() {
        return this._height;
    }

    public Paint getPaint() {
        return this._g.getPaint();
    }

    public Stroke getStroke() {
        return this._g.getStroke();
    }

    public double getWidth() {
        return this._width;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this._g.hit(rect, s, onStroke);
    }

    public boolean hitClip(double x, double y, double width, double height) {
        return this._g.hitClip(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void setBackground(Color color) {
        this._g.setBackground(color);
    }

    public void setClip(double x, double y, double width, double height) {
        this._g.setClip(Canvas.i(x), Canvas.i(y), Canvas.i(width), Canvas.i(height));
    }

    public void setClip(Shape clip) {
        this._g.setClip(clip);
    }

    public void setColor(Color c) {
        this._g.setColor(c);
    }

    public void setFont(Font font) {
        this._g.setFont(font);
    }

    public void setPaint(Paint paint) {
        this._g.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        this._g.setStroke(stroke);
    }

    private static int i(double d) {
        return (int)Math.round(d);
    }

    public static enum Align {
        LEFT{

            @Override
            public double calculateDeltaX(Canvas c, String str) {
                return 0.0;
            }

            @Override
            public double calculateX(Canvas c, String str, double minX, double maxX) {
                return minX;
            }
        }
        ,
        CENTER{

            @Override
            public double calculateDeltaX(Canvas c, String str) {
                return -c.getFontMetrics().stringWidth(str) / 2;
            }

            @Override
            public double calculateX(Canvas c, String str, double minX, double maxX) {
                return (maxX + minX) / 2.0 + this.calculateDeltaX(c, str);
            }
        }
        ,
        RIGHT{

            @Override
            public double calculateDeltaX(Canvas c, String str) {
                return -c.getFontMetrics().stringWidth(str);
            }

            @Override
            public double calculateX(Canvas c, String str, double minX, double maxX) {
                return maxX + this.calculateDeltaX(c, str);
            }
        };


        public abstract double calculateDeltaX(Canvas var1, String var2);

        public abstract double calculateX(Canvas var1, String var2, double var3, double var5);

        public final void drawString(Canvas c, String str, double x, double y) {
            c.drawString(str, x + this.calculateDeltaX(c, str), y);
        }
    }
}

