/*
 * Decompiled with CFR 0.152.
 */
package rijteam;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import rijteam.Enemy;
import rijteam.EnemyBullet;
import rijteam.Util;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SmartDodge
extends AdvancedRobot {
    static double PI = Math.PI;
    static double WALL_STICK = 160.0;
    Enemy Target;
    int direction;
    double firePower;
    double oldEnergy;
    double newEnergy;
    int bulletsFired;
    int bulletsMissed;
    int bulletsHit;
    int bulletsScored;
    Vector EnemyBullets;
    Rectangle2D _fieldRect;
    double _bfWidth;
    double _bfHeight;

    public void run() {
        this.Target = new Enemy();
        this.setColors(Color.red, Color.blue, Color.green);
        this._fieldRect = new Rectangle2D.Double(30.0, 30.0, this.getBattleFieldWidth() - 60.0, this.getBattleFieldHeight() - 60.0);
        this._bfWidth = this.getBattleFieldWidth();
        this._bfHeight = this.getBattleFieldHeight();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians((double)2 * PI);
        while (true) {
            this.doMovement();
            this.voidBullets();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            this.fire(this.firePower);
            this.execute();
        }
    }

    void doFirePower() {
        this.firePower = (double)(600 * ((this.bulletsScored + 1) / (this.bulletsHit + 1))) / this.Target.distance;
    }

    void voidBullets() {
        int i = 1;
        long curTime = this.getTime();
        double curX = this.getX();
        double curY = this.getY();
        i = 0;
        while (i < this.EnemyBullets.size()) {
            EnemyBullet curBullet = (EnemyBullet)this.EnemyBullets.elementAt(i);
            if (curBullet.isBulletMissed(curTime, curX, curY)) {
                this.EnemyBullets.removeElementAt(i);
                ++this.bulletsMissed;
            }
            ++i;
        }
    }

    void doMovement() {
        double forceCos = 0.0;
        double forceSin = 0.0;
        double x = this.getX();
        double y = this.getY();
        double myHeading = this.getHeading();
        Point2D BulletApproach = new Point2D.Double();
        Point2D.Double myLocation = new Point2D.Double(x, y);
        long curTime = this.getTime();
        int i = 0;
        i = 0;
        while (i < this.EnemyBullets.size()) {
            EnemyBullet curBullet = (EnemyBullet)this.EnemyBullets.elementAt(i);
            BulletApproach = curBullet.findClosest(myLocation);
            double approachX = BulletApproach.getX();
            double approachY = BulletApproach.getY();
            double distApproach = Util.getrange(x, y, approachX, approachY);
            double approachBearing = Util.getRelativeBearing(myHeading, x, y, approachX, approachY);
            forceCos += curBullet.BulletPower / Math.pow(distApproach, 2) * Math.cos(approachBearing);
            forceSin += curBullet.BulletPower / Math.pow(distApproach, 2) * Math.sin(approachBearing);
            ++i;
        }
        double resForceMag = Math.sqrt(Math.pow(forceCos, 2) + Math.pow(forceSin, 2));
        double resForceBearing = Math.atan(forceSin / forceCos);
        double angle = this.smallestToParallel(resForceBearing);
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, this._bfWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this._bfHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this._bfWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this._bfHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!this._fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.01) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, this._bfWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this._bfHeight - testY - 18.0);
        }
        angle = angle < 0.0 ? (angle += (double)2 * PI) : (angle %= (double)2 * PI);
        this.setAhead(resForceMag * 1000000.0);
        if (angle > myHeading) {
            if (angle - myHeading > PI) {
                this.setTurnLeftRadians(angle - myHeading);
            } else {
                this.setTurnRightRadians(angle - myHeading);
            }
        } else if (myHeading - angle > PI) {
            this.setTurnRightRadians(myHeading - angle);
        } else {
            this.setTurnLeftRadians(myHeading - angle);
        }
        this.execute();
    }

    public double smallestToParallel(double angle) {
        if (angle > -PI && angle <= PI) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -PI) {
            fixedAngle += (double)2 * PI;
        }
        while (fixedAngle > PI) {
            fixedAngle -= (double)2 * PI;
        }
        return fixedAngle;
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.Target.ctime > (long)4 ? 360.0 : ((radarOffset = this.getRadarHeadingRadians() - Util.absbearing(this.getX(), this.getY(), this.Target.x, this.Target.y)) < 0.0 ? (radarOffset -= PI / 8.0) : (radarOffset += PI / 8.0));
        this.setTurnRadarLeftRadians(Util.NormaliseBearing(radarOffset));
    }

    void doGun() {
        long time = this.getTime() + (long)((int)(this.Target.distance / (20.0 - (double)3 * this.firePower)));
        double gunOffset = this.getGunHeadingRadians() - Util.absbearing(this.getX(), this.getY(), this.Target.guessX(time), this.Target.guessY(time));
        this.setTurnGunLeftRadians(Util.NormaliseBearing(gunOffset));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.newEnergy = e.getEnergy();
        double shotPower = this.oldEnergy - this.newEnergy;
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % ((double)2 * PI);
        double lastBearing = Util.getUnitCircleAngle(this.getHeadingRadians() + e.getBearingRadians());
        this.Target.name = e.getName();
        this.Target.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        this.Target.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        this.Target.bearing = e.getBearingRadians();
        this.Target.head = e.getHeadingRadians();
        this.Target.ctime = this.getTime();
        this.Target.speed = e.getVelocity();
        this.Target.energy = this.newEnergy;
        this.Target.distance = e.getDistance();
        if (shotPower >= 0.09 && shotPower <= 3.01) {
            double myX = this.getX();
            double myY = this.getY();
            this.out.println("bullet fired at X:" + this.Target.x + " Y:" + this.Target.y);
            this.out.println(" Bullets Fired at me:" + this.bulletsFired + " bullets dodged:" + this.bulletsMissed + " bullets hit:" + this.bulletsHit + " Hits Made:" + this.bulletsScored);
            ++this.bulletsFired;
            EnemyBullet newBullet = new EnemyBullet(this.Target.x, this.Target.y, this.Target.distance, this.Target.head, this.getTime(), shotPower);
            this.EnemyBullets.add(newBullet);
        }
        this.oldEnergy = this.newEnergy;
    }

    public void onHitByBullet(HitByBulletEvent hbbe) {
        ++this.bulletsHit;
    }

    public void onWin(WinEvent e) {
        this.out.println("You can't bend the spoon, it's impossible, instead think that there is no spoon");
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.bulletsScored;
    }

    public void onHitWall(HitWallEvent hwe) {
        this.direction *= -1;
        this.turnRightRadians(hwe.getBearingRadians() + PI / (double)2);
        this.setAhead(this.direction * 300);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.Target.name) {
            this.Target.distance = 10000.0;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.out.println("skipped turn " + this.getTime());
    }

    private final /* synthetic */ void this() {
        this.direction = 1;
        this.oldEnergy = 0.0;
        this.newEnergy = 0.0;
        this.bulletsFired = 0;
        this.bulletsMissed = 0;
        this.bulletsHit = 0;
        this.bulletsScored = 0;
        this.EnemyBullets = new Vector();
    }

    public SmartDodge() {
        this.this();
    }
}

