/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.manager;

import de._4geeks.robots.guns.Gun;
import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.utils.MEASim;
import de._4geeks.robots.utils.SUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.util.Utils;

public class Wave
extends Condition {
    private AdvancedRobot robot;
    private Gun gun;
    private EnemyScan enemy;
    private Bullet bullet;
    private double firePower;
    private long fireTime;
    private int round;
    private double startX;
    private double startY;
    private double targetX;
    private double targetY;
    private ArrayList<Double> guessFactors;
    private double realGuessFactor = 0.0;
    private double distanceChange = 0.0;
    public boolean hit = false;
    private boolean passed = false;
    private double forwardMaxEscapeAngle;
    private double reverseMaxEscapeAngle;

    public Wave(AdvancedRobot robot, Gun gun, EnemyScan enemy, double firePower) {
        this.robot = robot;
        this.gun = gun;
        this.enemy = enemy;
        this.round = robot.getRoundNum();
        this.firePower = firePower;
        this.startX = robot.getX();
        this.startY = robot.getY();
        MEASim sim = new MEASim(robot);
        this.forwardMaxEscapeAngle = sim.forwardSim(this, this.startX, this.startY);
        this.reverseMaxEscapeAngle = sim.backwardSim(this, this.startX, this.startY);
    }

    public void fire() {
        this.fireTime = this.robot.getTime();
        this.startX = this.robot.getX();
        this.startY = this.robot.getY();
        this.robot.addCustomEvent((Condition)this);
        this.bullet = null;
    }

    public void fire(Bullet bullet) {
        this.fireTime = this.robot.getTime();
        this.startX = this.robot.getX();
        this.startY = this.robot.getY();
        this.robot.addCustomEvent((Condition)this);
        this.bullet = bullet;
        this.firePower = bullet.getPower();
    }

    public void addGuess(double gf) {
        if (this.guessFactors == null) {
            this.guessFactors = new ArrayList();
        }
        this.guessFactors.add(gf);
    }

    public double getGuess(int i) {
        return this.guessFactors.get(i);
    }

    public boolean isFiringWave() {
        return this.bullet != null;
    }

    public boolean test() {
        EnemyScan target = this.gun.getEnemy();
        if (target == null || this.enemy.getName() != target.getName()) {
            this.robot.removeCustomEvent((Condition)this);
            return false;
        }
        double distance = Point2D.Double.distance(this.startX, this.startY, target.getX(), target.getY());
        double velocity = 20.0 - 3.0 * this.firePower;
        if (distance <= (double)(this.robot.getTime() - this.fireTime) * velocity) {
            this.targetX = target.getX();
            this.targetY = target.getY();
            this.gun.registerWave(this);
            this.robot.removeCustomEvent((Condition)this);
            double desiredDirection = Math.atan2(this.targetX - this.startX, this.targetY - this.startY);
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.enemy.getAbsoluteBearing())) * SUtils.sign(this.enemy.getAngularVelocity());
            this.realGuessFactor = angleOffset / (angleOffset > 0.0 ? Math.abs(this.forwardMaxEscapeAngle) : Math.abs(this.reverseMaxEscapeAngle));
            this.distanceChange = distance - target.getDistance();
            this.passed = true;
        }
        return false;
    }

    public double getTargetX() {
        return this.targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public double getGuessFactor() {
        return this.realGuessFactor;
    }

    public double[] getFeatures() {
        return this.enemy.getFeatures();
    }

    public EnemyScan getEnemy() {
        return this.enemy;
    }

    public boolean isHit() {
        return this.hit;
    }

    public void bulletHitTest(Bullet b) {
        if (this.bullet != null && this.bullet.equals(b)) {
            this.hit = true;
        }
    }

    public boolean testHit(double guess) {
        EnemyScan target = this.gun.getEnemy();
        double distance = Point2D.Double.distance(this.startX, this.startY, target.getX(), target.getY());
        boolean both = guess * this.realGuessFactor < 0.0;
        double x = 0.0;
        if (both) {
            x += Math.abs(guess) * guess > 0.0 ? Math.abs(this.forwardMaxEscapeAngle) : Math.abs(this.reverseMaxEscapeAngle);
            x += Math.abs(this.realGuessFactor) * this.realGuessFactor > 0.0 ? Math.abs(this.forwardMaxEscapeAngle) : Math.abs(this.reverseMaxEscapeAngle);
            x = Math.tan(x) * distance;
        } else {
            double mea = guess > 0.0 ? Math.abs(this.forwardMaxEscapeAngle) : Math.abs(this.reverseMaxEscapeAngle);
            x = Math.tan((guess - this.realGuessFactor) * mea) * distance;
        }
        return Math.abs(x) < 18.0;
    }

    public int getRound() {
        return this.round;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public double getDistanceChange() {
        return this.distanceChange;
    }

    public long getFireTime() {
        return this.fireTime;
    }

    public void onPaint(Graphics2D g) {
        double velocity = 20.0 - 3.0 * this.firePower;
        int r = (int)((double)(this.robot.getTime() - this.fireTime) * velocity);
        if (this.isFiringWave()) {
            g.setColor(Color.RED);
            g.drawOval((int)this.startX - r, (int)this.startY - r, 2 * r, 2 * r);
        }
        if (this.realGuessFactor != 0.0 && this.isFiringWave()) {
            double gf = this.enemy.getAbsoluteBearing() + this.realGuessFactor * Math.asin(8.0 / (20.0 - 3.0 * this.firePower)) * SUtils.sign(this.enemy.getAngularVelocity());
            g.drawLine((int)this.startX, (int)this.startY, (int)(this.startX + Math.sin(gf) * (double)r), (int)(this.startY + Math.cos(gf) * (double)r));
        }
    }

    public boolean isPassed() {
        return this.passed;
    }

    public double getForwardMaxEscapeAngle() {
        return this.forwardMaxEscapeAngle;
    }

    public double getReverseMaxEscapeAngle() {
        return this.reverseMaxEscapeAngle;
    }
}

