/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun.gun;

import dsekercioglu.mega.core.DistancedGuessFactor;
import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.KNNView;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rGun.BattleInfo;
import dsekercioglu.mega.rGun.gun.Predictor;
import java.util.ArrayList;

public class MainGun
extends Predictor {
    final double[] WEIGHTS = new double[]{6.47, 3.64, 8.151, 6.32, 0.98, 9.02, 2.74};
    final int K = 125;
    final int DIVISOR = 1;
    KNNView knnView = new KNNView(125, 1, this.WEIGHTS);

    public MainGun() {
        this.knnView.addDataPoint(new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5}, new GuessFactor(0.0, 1.0E-4, 0));
    }

    @Override
    public ArrayList<GuessFactor> getGuessFactors(BattleInfo battleInfo) {
        ArrayList<DistancedGuessFactor> guessFactors = this.knnView.nearestNeighbours(this.getDataPoint(battleInfo));
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        for (DistancedGuessFactor distancedGuessFactor : guessFactors) {
            GuessFactor guessFactor = distancedGuessFactor.getGuessFactor();
            GuessFactor weightedGuessFactor = new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight() / (1.0 + distancedGuessFactor.getDistance()), guessFactor.SCAN);
            weightedGuessFactors.add(weightedGuessFactor);
        }
        return weightedGuessFactors;
    }

    @Override
    public void addData(BattleInfo battleInfo, GuessFactor guessFactor, boolean real) {
        this.knnView.addDataPoint(this.getDataPoint(battleInfo), guessFactor);
    }

    public double[] getDataPoint(BattleInfo battleInfo) {
        double mea = FastMath.asin(8.0 / (20.0 - 3.0 * battleInfo.getLastFirePower()));
        return new double[]{Math.abs(battleInfo.getEnemyLateralVelocity()) / 8.0, (battleInfo.getEnemyAdvancingVelocity() + 8.0) / 16.0, battleInfo.getBotDistance() / (20.0 - 3.0 * battleInfo.getLastFirePower()) / 91.0, Math.min(battleInfo.getMEA(1) / mea, 1.0), Math.min(battleInfo.getMEA(-1) / mea, 1.0), (battleInfo.getEnemyLateralAcceleration() + 2.0) / 3.0, 1.0 / (1.0 + battleInfo.getEnemyTimeSinceDeceleration() * 2.0)};
    }
}

