/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.AngleUtils;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.util.Utils;

public class RamMoving
extends RobotModule {
    protected Tracking tracking;

    public RamMoving(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot);
        this.tracking = tracking;
    }

    @Override
    public void init() {
    }

    @Override
    public void turn() {
        Opponent opponent = this.tracking.getLastHitBy();
        Position position = null;
        if (opponent != null && !opponent.isDead()) {
            if (this.tracking.getClosestBullet() == null && this.robot.getEnergy() > 0.71) {
                if (opponent.getLastEnergy() <= 0.1) {
                    Log.log(3, "Fatality!!!");
                    position = opponent.getLastPosition();
                } else if (opponent.getLastEnergy() <= 0.6) {
                    Position position2 = new Position((Robot)this.robot);
                    if (position2.distance(opponent.getLastPosition()) < 100.0) {
                        Log.log(3, "Ram!!!");
                        position = opponent.getLastPosition();
                    }
                }
            }
            if (position != null) {
                Position position3 = new Position((Robot)this.robot);
                position3.modify((long)Math.abs(this.robot.getVelocity() / 2.0), this.robot.getVelocity() / 2.0, this.robot.getHeadingRadians());
                int n = 1;
                double d = AngleUtils.difference(this.robot.getHeadingRadians(), position3.getDirectionTo(position));
                if (Math.abs(d) > 1.5707963267948966) {
                    n *= -1;
                    d = Utils.normalRelativeAngle((double)(d + Math.PI));
                }
                this.robot.setAhead((double)(30 * n));
                this.robot.setTurnRightRadians(d * (double)n);
            }
        }
    }
}

