/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.CalendarMoving;
import pa3k.CalendarMovingTask;
import pa3k.Log;
import pa3k.TaskExecutor;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class RandomChangeMoving
extends CalendarMoving {
    protected BulletTracking seenAlready;
    protected int timeToDirChange = 0;
    protected boolean fullSpeed;

    public RandomChangeMoving(AdvancedRobot advancedRobot, Tracking tracking, boolean bl) {
        super(advancedRobot, tracking);
        this.fullSpeed = bl;
        this.seenAlready = null;
    }

    @Override
    public void init() {
        super.init();
        this.scheduleDirectionChange(10L);
        if (!this.fullSpeed) {
            this.scheduleSlowSpell(20L);
        }
    }

    @Override
    public void turn() {
        super.turn();
    }

    protected void scheduleSlowSpell(long l) {
        Log.log(3, "Scheduling slow spell in " + l + " turns");
        long l2 = this.robot.getTime();
        CalendarMovingTask calendarMovingTask = new CalendarMovingTask(l2 + l, new TaskExecutor(){

            @Override
            public void execute(CalendarMoving calendarMoving, CalendarMovingTask calendarMovingTask) {
                int n = Utils.getRandom().nextInt(20);
                calendarMoving.setMaxSpeed(n);
                RandomChangeMoving.this.scheduleSlowSpell(Utils.getRandom().nextInt(10) + 4);
            }
        });
        this.addTask(calendarMovingTask);
    }

    protected void scheduleDirectionChange(long l) {
        Log.log(3, "Scheduling direction change in " + l + " turns");
        long l2 = this.robot.getTime();
        CalendarMovingTask calendarMovingTask = new CalendarMovingTask(l2 + l, new TaskExecutor(){

            @Override
            public void execute(CalendarMoving calendarMoving, CalendarMovingTask calendarMovingTask) {
                RandomChangeMoving.this.direction *= -1;
                RandomChangeMoving.this.scheduleDirectionChange(Utils.getRandom().nextInt(30) + 60);
            }
        });
        this.addTask(calendarMovingTask);
    }
}

