/*
 * Decompiled with CFR 0.152.
 */
package robo;

import robo.EnemyBot;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class AdvancedEnemyBot
extends EnemyBot {
    private double x;
    private double y;
    private long time;

    public AdvancedEnemyBot() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.x = 0.0;
        this.y = 0.0;
        this.time = 0L;
    }

    public void update(ScannedRobotEvent sre, Robot robo) {
        super.update(sre);
        this.time = robo.getTime();
        double absBearingDeg = robo.getHeading() + sre.getBearing();
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        this.x = robo.getX() + Math.sin(Math.toRadians(absBearingDeg)) * sre.getDistance();
        this.y = robo.getY() + Math.cos(Math.toRadians(absBearingDeg)) * sre.getDistance();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public long getTime() {
        return this.time;
    }

    public double getFutureX(long when) {
        return this.x + Math.sin(Math.toRadians(this.getHeading())) * this.getVelocity() * (double)when;
    }

    public double getFutureY(long when) {
        return this.y + Math.cos(Math.toRadians(this.getHeading())) * this.getVelocity() * (double)when;
    }
}

