/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.wave;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRectangle;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.wave.RWave;
import rampancy.util.weapon.RFiringSolution;

public class RBulletWave
extends RWave {
    public static final Color DEFAULT_COLOR = Color.green;
    public static final Color ANTICIPATED_COLOR = Color.pink;
    public static final int ANTICIPATED_RADIUS = 4;
    protected REnemyRobot target;
    protected RRobotState targetState;
    protected RRobotState creatorState;
    protected RFiringSolution firingSolution;
    protected RPoint bulletLocation;
    protected double absoluteFiringAngle;
    protected boolean didHit;

    public RBulletWave(REnemyRobot target, RFiringSolution firingSolution) {
        this(target, firingSolution, false);
    }

    public RBulletWave(REnemyRobot target, RFiringSolution firingSolution, boolean virtual) {
        super(target.getReference().getCopyOfLocation(), target.getReference().getTime(), firingSolution.power, firingSolution.color, virtual, firingSolution.drawableObject);
        this.target = target;
        this.targetState = target.getCurrentState().getCopy();
        this.creatorState = target.getReference().getCurrentState();
        this.firingSolution = firingSolution;
        this.absoluteFiringAngle = target.getReference().getGunHeadingRadians();
        this.bulletLocation = this.origin.getCopy();
        this.didHit = false;
    }

    public void update(long time) {
        super.update(time);
        this.bulletLocation = RUtil.project(this.origin, this.absoluteFiringAngle, this.distanceTraveled);
        if (RUtil.pointOnRobot(this.bulletLocation, this.getTarget())) {
            this.didHit = true;
        }
    }

    public boolean didBreak() {
        return this.distanceTraveled > this.target.getCurrentState().location.distance(this.origin) + 50.0;
    }

    public REnemyRobot getTarget() {
        return this.target;
    }

    public RRobotState getTargetState() {
        return this.targetState;
    }

    public RRobotState getCreatorState() {
        return this.creatorState;
    }

    public RFiringSolution getFiringSolution() {
        return this.firingSolution;
    }

    public RPoint getAnticipatedImpactLocation() {
        return this.firingSolution.intendedHitLocation;
    }

    public double getAbsoluteFiringAngle() {
        return this.absoluteFiringAngle;
    }

    public RPoint getBulletLocation() {
        return this.bulletLocation;
    }

    public boolean didHitEnemy() {
        return this.didHit;
    }

    public void draw(Graphics2D g) {
        if (this.isVirtual()) {
            return;
        }
        if (this.firingSolution.intendedHitLocation == null) {
            super.draw(g);
            return;
        }
        if (this.drawableObject != null) {
            this.drawableObject.draw(g);
        }
        g.setColor(ANTICIPATED_COLOR);
        RUtil.fillOval(this.firingSolution.intendedHitLocation, 4, g);
        g.draw(new RRectangle(this.firingSolution.intendedHitLocation));
        double angle = RUtil.computeAbsoluteBearing(this.getOrigin(), this.firingSolution.intendedHitLocation);
        RPoint currentPosition = RUtil.project(this.getOrigin(), angle, this.getDistanceTraveled());
        if (this.getDistanceTraveled() > this.getOrigin().distance(this.firingSolution.intendedHitLocation)) {
            return;
        }
        g.draw(new Line2D.Double(currentPosition, this.firingSolution.intendedHitLocation));
    }
}

