/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.enemy;

import dmh.robocode.bullet.PerfectSimulatedBullet;
import dmh.robocode.data.AverageLocation;
import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.DynamicMovementSequence;
import dmh.robocode.data.Location;
import dmh.robocode.data.LocationLog;
import dmh.robocode.data.Movement;
import dmh.robocode.data.PerfectHitMovement;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.data.RadarObservationList;
import dmh.robocode.data.ShotAtEnemy;
import dmh.robocode.data.ShotByEnemy;
import dmh.robocode.enemy.EnemyRobotMovementAnalyser;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.gunner.enemy.EnemyShootAtMyCurrentLocation;
import dmh.robocode.gunner.enemy.EnemyShootingAtUsStrategy;
import dmh.robocode.key.TimeAndHeadingKey;
import dmh.robocode.key.ZoneToZoneKey;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import robocode.Rules;

public class EnemyRobot {
    private static final int LOCATION_LOG_SIZE = 500;
    private static final int LOCATION_LOG_INCREMENT = 500;
    private String name;
    private boolean isLearningAllowed = true;
    private boolean isAlive = true;
    long timeOfNextShot = 0L;
    double optimumAttackDistance = 200.0;
    private AverageLocation averageLocation;
    private AverageLocation averageFutureLocation;
    private RadarObservationList observations;
    private List<ShotAtEnemy> shotAtEnemyHistory;
    private List<ShotByEnemy> shotByEnemyHistory;
    private List<AimingStrategy> aimingStrategies;
    private List<EnemyShootingAtUsStrategy> shootingAtUsStrategies;
    private Map<Byte, ArrayList<PerfectHitMovement>> perfectHitMovementsByZone = new HashMap<Byte, ArrayList<PerfectHitMovement>>();
    private Map<Long, ArrayList<PerfectHitMovement>> perfectHitMovementsByExpectedTravelTime = new HashMap<Long, ArrayList<PerfectHitMovement>>();
    private Map<TimeAndHeadingKey, ArrayList<PerfectHitMovement>> perfectHitMovementsByExpectedTimeAndEnemyHeading = new HashMap<TimeAndHeadingKey, ArrayList<PerfectHitMovement>>();
    private Map<ZoneToZoneKey, ArrayList<PerfectHitMovement>> perfectHitMovementsByZones = new HashMap<ZoneToZoneKey, ArrayList<PerfectHitMovement>>();
    private DynamicMovementSequence currentMovementSequence;
    private static double statisticDistanceRange = 50.0;
    private static short statisticNumberOfRanges = (short)20;
    private static int minShotsForGoodStatistic = 10;
    private static double averageLocationWeightingFactor = 1.05;
    private static double averageFutureLocationWeightingFactor = 1.1;
    private static long futureTurns = 30L;
    private double[] damageRatios = new double[statisticNumberOfRanges];
    private double[] shootingAccuracies = new double[statisticNumberOfRanges];
    private double damageRatio = 0.0;
    private double shootingAccuracy = 50.0;
    private EnemyRobotMovementAnalyser movementAnalyser;
    private long predictedHits;
    private LocationLog currentRoundLocationLog;
    private EnemyShootAtMyCurrentLocation strategyEnemyShootAtMyCurrentLocation;

    public EnemyRobot(String name) {
        this.name = name;
        this.observations = new RadarObservationList();
        this.currentMovementSequence = new DynamicMovementSequence();
        this.shotAtEnemyHistory = new ArrayList<ShotAtEnemy>();
        this.shotByEnemyHistory = new ArrayList<ShotByEnemy>();
        this.movementAnalyser = new EnemyRobotMovementAnalyser();
        this.aimingStrategies = new ArrayList<AimingStrategy>();
        this.shootingAtUsStrategies = new ArrayList<EnemyShootingAtUsStrategy>();
        this.averageLocation = new AverageLocation(averageLocationWeightingFactor);
        this.averageFutureLocation = new AverageLocation(averageFutureLocationWeightingFactor);
        this.currentRoundLocationLog = new LocationLog(500, 500);
        for (int range = 0; range < statisticNumberOfRanges; ++range) {
            this.damageRatios[range] = this.damageRatio;
            this.shootingAccuracies[range] = this.shootingAccuracy;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<RadarObservation> getObservationsSince(long earliestTime) {
        return this.observations.getAllSince(earliestTime);
    }

    public void processScannedRobotEvent(String enemyName, RadarObservation newRadarObservation) {
        if (enemyName.equals(this.name)) {
            this.observations.add(newRadarObservation);
            this.recordLatestMovement();
            this.averageLocation.recordLocation(newRadarObservation.getLocation());
            this.averageFutureLocation.recordLocation(Geometry.getLocationAtBearing(newRadarObservation.getLocation(), newRadarObservation.getHeading(), (double)futureTurns * newRadarObservation.getVelocity()));
            this.currentRoundLocationLog.record(newRadarObservation.getLocation(), (int)newRadarObservation.getTimeSeen());
        }
    }

    private void recordLatestMovement() {
        RadarObservation previousObservation = this.getPreviousRadarObservation();
        RadarObservation latestObservation = this.getLatestRadarObservation();
        if (previousObservation != null && previousObservation.getTimeSeen() == latestObservation.getTimeSeen() - 1L) {
            double rateOfTurn = Geometry.getRelativeBearing(previousObservation.getHeading(), latestObservation.getHeading());
            double distance = latestObservation.getVelocity();
            Movement movement = new Movement(rateOfTurn, distance);
            this.currentMovementSequence.add(movement, latestObservation.getTimeSeen());
            this.movementAnalyser.notifyNewMovement(this.currentMovementSequence, latestObservation.getTimeSeen());
        }
    }

    public EnemyRobotMovementAnalyser getMovementAnalyser() {
        return this.movementAnalyser;
    }

    public Location getLocationAtTime(long time) {
        return this.currentRoundLocationLog.getAtTime((int)time);
    }

    public RadarObservation getLatestRadarObservation() {
        return this.observations.getLatest();
    }

    public RadarObservation getPreviousRadarObservation() {
        return this.observations.getPrevious();
    }

    public RadarObservation getObservationAtTime(long time) {
        return this.observations.getObservationAtTime(time);
    }

    public DynamicMovementSequence getCurrentMovementSequence() {
        return this.currentMovementSequence;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public int getNumberOfShotsThatHitUs() {
        return this.shotByEnemyHistory.size();
    }

    public void processRobotDeathEvent(String deadRobotName) {
        if (deadRobotName.equals(this.name)) {
            this.isAlive = false;
        }
    }

    public List<ShotAtEnemy> getShotAtEnemyHistory() {
        return this.shotAtEnemyHistory;
    }

    public List<ShotByEnemy> getShotByEnemyHistory() {
        return this.shotByEnemyHistory;
    }

    public double getDamageRatio() {
        return this.damageRatio;
    }

    public void resetForNextRound() {
        this.isAlive = true;
        this.currentMovementSequence = new DynamicMovementSequence();
        this.observations = new RadarObservationList();
        if (this.isLearningAllowed) {
            this.updateStatistics();
        }
        this.movementAnalyser.resetForNextRound();
        this.averageLocation = new AverageLocation(averageLocationWeightingFactor);
        this.averageFutureLocation = new AverageLocation(averageFutureLocationWeightingFactor);
        this.currentRoundLocationLog = new LocationLog(500, 500);
        this.timeOfNextShot = 0L;
    }

    public void recordMyShot(String category, ShotAtEnemy myShot) {
        this.shotAtEnemyHistory.add(myShot);
        for (AimingStrategy strategy : this.aimingStrategies) {
            strategy.notifyShotJustFired();
        }
    }

    public void simulatePossibleShots(String category, ShotAtEnemy myShot) {
        for (AimingStrategy strategy : this.aimingStrategies) {
            strategy.simulateShot(category, Rules.getBulletSpeed((double)myShot.getBulletPower()));
        }
    }

    public void recordEnemyHitUs(ShotByEnemy shotDetails, boolean wasHitPredicted) {
        this.shotByEnemyHistory.add(shotDetails);
        if (wasHitPredicted) {
            ++this.predictedHits;
        }
    }

    public long getPredictedHits() {
        return this.predictedHits;
    }

    private void updateStatistics() {
        double allHitDamage = 0.0;
        double allMissDamage = 0.0;
        int allShots = 0;
        int allHits = 0;
        double[] hitDamage = new double[statisticNumberOfRanges];
        double[] missDamage = new double[statisticNumberOfRanges];
        int[] shots = new int[statisticNumberOfRanges];
        int[] hits = new int[statisticNumberOfRanges];
        for (ShotAtEnemy shot : this.shotAtEnemyHistory) {
            short range = this.turnDistanceIntoStatisticRange(shot.getEnemyDistance());
            switch (shot.getStatus()) {
                case HIT_TARGET: {
                    allHitDamage += Rules.getBulletDamage((double)shot.getBulletPower());
                    ++allShots;
                    ++allHits;
                    short s = range;
                    hitDamage[s] = hitDamage[s] + Rules.getBulletDamage((double)shot.getBulletPower());
                    short s2 = range;
                    shots[s2] = shots[s2] + 1;
                    short s3 = range;
                    hits[s3] = hits[s3] + 1;
                    break;
                }
                case MISS: {
                    allMissDamage += Rules.getBulletDamage((double)shot.getBulletPower());
                    ++allShots;
                    short s = range;
                    missDamage[s] = missDamage[s] + Rules.getBulletDamage((double)shot.getBulletPower());
                    short s4 = range;
                    shots[s4] = shots[s4] + 1;
                    break;
                }
            }
        }
        double allDamageReceived = 0.0;
        double[] damageReceived = new double[statisticNumberOfRanges];
        for (ShotByEnemy shot : this.shotByEnemyHistory) {
            allDamageReceived += Rules.getBulletDamage((double)shot.getBulletPower());
            if (shot.getEnemyDistance() == ShotByEnemy.unknownEnemyDistance) continue;
            short s = this.turnDistanceIntoStatisticRange(shot.getEnemyDistance());
            damageReceived[s] = damageReceived[s] + Rules.getBulletDamage((double)shot.getBulletPower());
        }
        if (allShots >= minShotsForGoodStatistic) {
            this.damageRatio = (allHitDamage - allDamageReceived) * 100.0 / (allHitDamage + allMissDamage);
            this.shootingAccuracy = (double)allHits * 100.0 / (double)allShots;
        }
        for (int range = 0; range < statisticNumberOfRanges; ++range) {
            if (shots[range] >= minShotsForGoodStatistic) {
                this.damageRatios[range] = (hitDamage[range] - damageReceived[range]) * 100.0 / (hitDamage[range] + missDamage[range]);
                this.shootingAccuracies[range] = (double)hits[range] * 100.0 / (double)shots[range];
                continue;
            }
            this.damageRatios[range] = this.damageRatio;
            this.shootingAccuracies[range] = this.shootingAccuracy;
        }
        this.recalculateOptimumAttackDistance();
    }

    private void recalculateOptimumAttackDistance() {
        double optimumAttackDamageRatio = -200.0;
        double attackDistance = 2.0 * statisticDistanceRange;
        for (int range = 1; range < statisticNumberOfRanges - 1; ++range) {
            double thisDamageRatio = Math.min(this.damageRatios[range], Math.min(this.damageRatios[range - 1], this.damageRatios[range + 1]));
            if (thisDamageRatio > optimumAttackDamageRatio) {
                optimumAttackDamageRatio = thisDamageRatio;
                this.optimumAttackDistance = attackDistance;
            }
            attackDistance += statisticDistanceRange;
        }
    }

    public double getOptimumAttackDistance() {
        return this.optimumAttackDistance;
    }

    public double getShootingAccuracy() {
        return this.shootingAccuracy;
    }

    public double getDamageRatio(double distance) {
        return this.damageRatios[this.turnDistanceIntoStatisticRange(distance)];
    }

    public double getShootingAccuracy(double distance) {
        return this.shootingAccuracies[this.turnDistanceIntoStatisticRange(distance)];
    }

    private short turnDistanceIntoStatisticRange(double distance) {
        double range = Math.floor(distance / statisticDistanceRange);
        return (short)Math.max(0.0, Math.min(range, (double)(statisticNumberOfRanges - 1)));
    }

    public String getStatisticsDebugString() {
        int range;
        System.out.println("Enemy : " + this.getName());
        System.out.println("    Damage Ratio =             " + (int)this.damageRatio + "%");
        System.out.println("    Shooting Accuracy =        " + (int)this.shootingAccuracy + "%");
        System.out.println("    Best attack distance =     " + this.optimumAttackDistance);
        System.out.println("    Predicted hits by enemy =  " + this.predictedHits);
        System.out.println("    Hits received from enemy = " + this.getNumberOfShotsThatHitUs());
        System.out.print("    Damage Ratio by Range : ");
        for (range = 0; range < statisticNumberOfRanges; ++range) {
            System.out.print((int)this.damageRatios[range] + "%  ");
        }
        System.out.println();
        System.out.print("    Shooting Accuracy by Range : ");
        for (range = 0; range < statisticNumberOfRanges; ++range) {
            System.out.print((int)this.shootingAccuracies[range] + "%  ");
        }
        System.out.println("\n");
        HashMap<AimingStrategy, Integer> strategyCounts = new HashMap<AimingStrategy, Integer>();
        for (ShotAtEnemy shotAtEnemy : this.shotAtEnemyHistory) {
            Integer count = (Integer)strategyCounts.get(shotAtEnemy.getAimingStrategy());
            strategyCounts.put(shotAtEnemy.getAimingStrategy(), count == null ? 1 : count + 1);
        }
        for (Map.Entry entry : strategyCounts.entrySet()) {
            System.out.println("    " + entry.getValue() + " x " + ((AimingStrategy)entry.getKey()).getFullName());
        }
        return "";
    }

    public double getDangerEnergy() {
        if (this.observations.getLatest() != null) {
            return (100.0 - this.damageRatio) / 100.0 * this.observations.getLatest().getEnergy();
        }
        return 0.0;
    }

    public double getDangerEnergyWithGravity(double safeDistance, Location myLocation) {
        double actualDistance;
        if (this.observations.getLatest() != null && (actualDistance = Geometry.getDistanceBetweenLocations(myLocation, this.observations.getLatest().getLocation())) < safeDistance) {
            return (safeDistance - actualDistance) / safeDistance * this.getDangerEnergy();
        }
        return 0.0;
    }

    public double getTargetEnergy() {
        if (this.observations.getLatest() != null) {
            return this.damageRatio / 100.0 * this.observations.getLatest().getEnergy();
        }
        return 100.0;
    }

    public double getTargetEnergyWithGravity(double shootingDistance, Location myLocation) {
        double actualDistance;
        if (this.observations.getLatest() != null && (actualDistance = Geometry.getDistanceBetweenLocations(myLocation, this.observations.getLatest().getLocation())) > shootingDistance) {
            if (this.getTargetEnergy() > 0.0) {
                return Math.max(0.0, (2.0 * shootingDistance - actualDistance) / shootingDistance * this.getTargetEnergy());
            }
            return Math.min(0.0, (2.0 * shootingDistance - actualDistance) / shootingDistance * this.getTargetEnergy());
        }
        return this.getTargetEnergy();
    }

    void setDamageRatioForTesting(double testDamageRatio) {
        this.damageRatio = testDamageRatio;
    }

    public DynamicMovementSequence getMovementSequenceCloneSinceTime(long sinceTime) {
        return this.currentMovementSequence.cloneMovementsSince(sinceTime);
    }

    public void addAimingStrategy(AimingStrategy strategy) {
        this.aimingStrategies.add(strategy);
    }

    public void removeAimingStrategy(AimingStrategy strategy) {
        this.aimingStrategies.remove(strategy);
    }

    public List<AimingStrategy> getAimingStrategies() {
        return this.aimingStrategies;
    }

    public void addShootingAtUsStrategy(EnemyShootingAtUsStrategy strategy) {
        this.shootingAtUsStrategies.add(strategy);
        if (strategy instanceof EnemyShootAtMyCurrentLocation) {
            this.strategyEnemyShootAtMyCurrentLocation = (EnemyShootAtMyCurrentLocation)strategy;
        }
    }

    public List<EnemyShootingAtUsStrategy> getShootingAtUsStrategies() {
        return this.shootingAtUsStrategies;
    }

    public boolean isAlwaysShootingAtCurrentLocation() {
        return this.strategyEnemyShootAtMyCurrentLocation != null && this.strategyEnemyShootAtMyCurrentLocation.isAlwaysUsed();
    }

    public void hasJustFired(double bulletPower, long time) {
        this.timeOfNextShot = time + (long)Math.ceil(Rules.getGunHeat((double)bulletPower) / BattleConstants.getInstance().getGunCoolingRate());
    }

    public long getTimeOfNextShot() {
        return this.timeOfNextShot;
    }

    public Location getAverageLocation() {
        return this.averageLocation.getAverageLocation();
    }

    public Location getAverageFutureLocation() {
        return this.averageFutureLocation.getAverageLocation();
    }

    public Location getLocationBehind(double distance) {
        double backwardsHeading = Geometry.getBearingBetweenLocations(this.getAverageFutureLocation(), this.getAverageLocation());
        return Geometry.getLocationAtBearing(this.getLatestRadarObservation().getLocation(), backwardsHeading, distance);
    }

    public void drawCircle(Graphics2D g, Color upToDateColour, Color fairlyRecentColour, int radius, long currentTime) {
        if (this.getLatestRadarObservation() != null) {
            long age = currentTime - this.getLatestRadarObservation().getTimeSeen();
            if (age == 0L) {
                this.drawCircle(g, upToDateColour, radius);
            } else if (age <= 20L) {
                this.drawCircle(g, fairlyRecentColour, radius);
            }
        }
    }

    public void drawCircle(Graphics2D g, Color colour, int radius) {
        if (this.getLatestRadarObservation() != null) {
            int x = (int)this.getLatestRadarObservation().getLocation().getX();
            int y = (int)this.getLatestRadarObservation().getLocation().getY();
            g.setColor(colour);
            g.drawOval(x - radius, y - radius, radius * 2, radius * 2);
        }
    }

    public void turnOffLearning() {
        this.isLearningAllowed = false;
    }

    public boolean isLearningAllowed() {
        return this.isLearningAllowed;
    }

    public void informPerfectHit(PerfectSimulatedBullet bullet) {
    }

    public void informPerfectHitTURNEDOFF(PerfectSimulatedBullet bullet) {
        byte myStartZone = bullet.getFiredFrom().getZone();
        byte enemyStartZone = bullet.getEnemyStartLocation().getZone();
        double enemyVelocity = bullet.getEnemyStartVelocity();
        double shootingDistance = Geometry.getDistanceBetweenLocations(bullet.getFiredFrom(), bullet.getEnemyStartLocation());
        double bulletVelocity = bullet.getVelocity();
        double movementDistance = Geometry.getDistanceBetweenLocations(bullet.getEnemyStartLocation(), bullet.getPerfectTarget());
        double movementBearing = Geometry.getBearingBetweenLocations(bullet.getEnemyStartLocation(), bullet.getPerfectTarget());
        double originalBearing = bullet.getEnemyStartHeading();
        double relativeBearing = Geometry.getRelativeBearing(originalBearing, movementBearing);
        long actualTravelTime = this.getLatestRadarObservation().getTimeSeen() - bullet.getStartTime();
        long expectedTravelTime = (int)Math.round(shootingDistance / bulletVelocity);
        PerfectHitMovement movement = new PerfectHitMovement(movementDistance, movementBearing, originalBearing, enemyVelocity);
        this.storePerfectHitMovement(movement, this.perfectHitMovementsByZone, enemyStartZone);
        this.storePerfectHitMovement(movement, this.perfectHitMovementsByExpectedTravelTime, expectedTravelTime);
        TimeAndHeadingKey timeAndHeadingKey = new TimeAndHeadingKey(expectedTravelTime, originalBearing, enemyVelocity, enemyStartZone);
        this.storePerfectHitMovement(movement, this.perfectHitMovementsByExpectedTimeAndEnemyHeading, timeAndHeadingKey);
        this.storePerfectHitMovement(movement, this.perfectHitMovementsByZones, new ZoneToZoneKey(myStartZone, enemyStartZone));
    }

    public <T> void storePerfectHitMovement(PerfectHitMovement movement, Map<T, ArrayList<PerfectHitMovement>> map, T key) {
        ArrayList<PerfectHitMovement> existingMovements = map.get(key);
        if (existingMovements == null) {
            existingMovements = new ArrayList();
            map.put(key, existingMovements);
        }
        existingMovements.add(movement);
    }

    public Map<Long, ArrayList<PerfectHitMovement>> getPerfectHitMovementsByExpectedTravelTime() {
        return this.perfectHitMovementsByExpectedTravelTime;
    }

    public Map<Byte, ArrayList<PerfectHitMovement>> getPerfectHitMovementsByZone() {
        return this.perfectHitMovementsByZone;
    }

    public Map<TimeAndHeadingKey, ArrayList<PerfectHitMovement>> getPerfectHitMovementsByExpectedTimeAndEnemyHeading() {
        return this.perfectHitMovementsByExpectedTimeAndEnemyHeading;
    }

    public Map<ZoneToZoneKey, ArrayList<PerfectHitMovement>> getPerfectHitMovementsByZones() {
        return this.perfectHitMovementsByZones;
    }

    public String getDataFileName() {
        int endPosition = this.name.indexOf(" (");
        if (endPosition == -1) {
            return this.name + ".txt";
        }
        return this.name.substring(0, endPosition) + ".txt";
    }

    public void recordStatsInDataFile(PrintStream p) {
        String details;
        for (EnemyShootingAtUsStrategy enemyShootingAtUsStrategy : this.shootingAtUsStrategies) {
            details = enemyShootingAtUsStrategy.getStatsAsString();
            if (details.isEmpty()) continue;
            p.println(enemyShootingAtUsStrategy.getUniqueShortId() + details);
        }
        for (AimingStrategy aimingStrategy : this.aimingStrategies) {
            details = aimingStrategy.getStatsAsString();
            if (details.isEmpty()) continue;
            p.println(aimingStrategy.getUniqueShortId() + details);
        }
    }

    public void processLineFromDataFile(String dataLine) {
        String[] splits = dataLine.split("\t", 2);
        if (splits.length == 2) {
            for (EnemyShootingAtUsStrategy enemyShootingAtUsStrategy : this.shootingAtUsStrategies) {
                if (!splits[0].equals(enemyShootingAtUsStrategy.getUniqueShortId())) continue;
                enemyShootingAtUsStrategy.processStatsAsString(splits[1]);
            }
            for (AimingStrategy aimingStrategy : this.aimingStrategies) {
                if (!splits[0].equals(aimingStrategy.getUniqueShortId())) continue;
                aimingStrategy.processStatsAsString(splits[1]);
            }
        }
    }
}

