/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Context;
import florent.Floater;
import florent.Gun;
import florent.MyEnemyWave;
import florent.Wave;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class FloatingTadpole
extends AdvancedRobot {
    private static final boolean monoGun = false;
    private static final boolean preciseFloater = false;
    private static final boolean apmFloater = false;
    private int timeSinceScan = 2;
    private static Context target;
    private static Floater floater;
    private Gun gun;
    static int skipped;
    private boolean scanned = false;
    private boolean gunActive = true;
    private boolean floaterActive = true;
    private boolean targetActive = true;
    private static int goodRound;
    private static final boolean debug = false;

    static {
        goodRound = 0;
    }

    public void run() {
        if (target == null && this.targetActive) {
            target = new Context(this);
        }
        if (this.gunActive) {
            this.gun = new Gun(this, target);
            this.gun.init();
        }
        if (floater == null && this.floaterActive) {
            floater = new Floater(target, this);
            floater.init();
        }
        if (this.floaterActive) {
            floater.newRound();
        }
        Wave.setContext(target);
        Wave.setRobot(this);
        MyEnemyWave.setContext(target);
        MyEnemyWave.setRobot(this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.gray.brighter(), Color.gray, Color.gray.darker());
        while (true) {
            if (this.targetActive) {
                target.synch();
            }
            if (this.floaterActive) {
                floater.newTick();
            }
            if (this.timeSinceScan++ > 1) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                if (this.floaterActive && this.scanned) {
                    floater.doMove();
                }
            }
            this.execute();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.floaterActive) {
            floater.onHitByBullet(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.floaterActive) {
            floater.onBulletHit(e);
        }
        if (this.gunActive) {
            this.gun.onBulletHit(e);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (this.floaterActive) {
            floater.onBulletHitBullet(e);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++skipped;
    }

    public void onHitWall(HitWallEvent e) {
        super.onHitWall(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.scanned = true;
        this.timeSinceScan = 0;
        if (this.floaterActive) {
            floater.onScannedRobot(e);
        }
        if (this.targetActive) {
            target.onScannedRobot(e);
        }
        if (this.gunActive) {
            this.gun.onScannedRobot(e);
            this.gun.aim();
        }
        if (this.floaterActive) {
            floater.doMove();
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians())) * 2.0);
    }

    public void onWin(WinEvent e) {
        this.endRound();
    }

    public void onDeath(DeathEvent e) {
        this.endRound();
    }

    public void endRound() {
        ++goodRound;
        if (this.floaterActive) {
            floater.endRound();
        }
        if (this.gunActive) {
            this.gun.endRound();
        }
    }

    private void dump() {
        if (this.floaterActive) {
            floater.dump();
        }
        if (this.gunActive) {
            this.gun.dump();
        }
        System.out.println("Skipped turns :" + skipped);
        System.out.println("finished rounds :" + goodRound + "/" + (this.getRoundNum() + 1));
    }

    public static double angleBetween(Point2D.Double origin, Point2D.Double p1, Point2D.Double p2) {
        return Utils.normalRelativeAngle((double)(FloatingTadpole.absoluteBearing(origin, p1) - FloatingTadpole.absoluteBearing(origin, p2)));
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    static void toLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static int getBestIndex(double[] bin) {
        int best = (bin.length - 1) / 2;
        int i = 1;
        while (i < bin.length) {
            if (bin[i] > bin[best]) {
                best = i;
            }
            ++i;
        }
        return best;
    }

    public static double rollingAverage(double n, double oldVal, double entry) {
        return (n * oldVal + entry) / (n + 1.0);
    }

    public static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    static int toGF(double angle, double[] bin) {
        return Math.min(Math.max((int)Math.round((angle + 1.0) * (double)(bin.length - 1) / 2.0), 1), bin.length - 1);
    }
}

