/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import justin.Mallais;
import justin.Scan;
import justin.Tank;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BulletM
extends Mallais {
    String name;
    Point2D.Double fireLocation;
    long fireTime;
    double velocity;
    double directAngle;
    double distanceTraveled;
    Point2D.Double bulletLocation;
    double mass;
    Point2D.Double targetLocation;
    AdvancedRobot robot;

    public void init(AdvancedRobot robot) {
        this.robot = robot;
    }

    public static void onScanBot(ScannedRobotEvent e, AdvancedRobot b) {
        Tank enemyData = Tank.get(e.getName());
        Scan oldData = Tank.getScan(e.getName(), -1);
        if (oldData == null) {
            return;
        }
        if (oldData.name == BulletM.targetScan.name | oldData.name == BulletM.myData.closestBotName | oldData.closestBotName == BulletM.myData.name) {
            double changeOfSpeed;
            long sinceScanned = b.getTime() - 1L - oldData.scanTime;
            if (sinceScanned > 9L || b.getTime() < 10L) {
                return;
            }
            double bulletPwr = oldData.energy - e.getEnergy();
            if (bulletPwr < 3.01 & bulletPwr > 0.09 & !((changeOfSpeed = Math.abs(oldData.speed - e.getVelocity())) > (double)(sinceScanned * 2L))) {
                BulletM bd;
                boolean loop = true;
                int i = 0;
                do {
                    bd = new BulletM();
                    bd.fireTime = b.getTime() - 1L + (long)i;
                    bd.name = e.getName();
                    bd.velocity = BulletM.velocity(bulletPwr);
                    enemyData.turnsTillGunHeatZero = (int)Math.round((1.0 + bulletPwr / 5.0) / b.getGunCoolingRate()) - i;
                    bd.distanceTraveled = bd.velocity * (double)(sinceScanned / 2L + (long)i);
                    bd.fireLocation = oldData.location;
                    bd.directAngle = Utils.normalAbsoluteAngle((double)(oldData.absBearing + Math.PI));
                    bd.targetLocation = BulletM.myData.location;
                    bd.bulletLocation = BulletM.project(bd.fireLocation, bd.directAngle, bd.distanceTraveled);
                    bulletList.add(bd);
                } while ((loop = battleField.contains(bd.bulletLocation)) && ++i < 120);
            }
        }
    }

    public static void updateBullets() {
        int x = 0;
        while (x < bulletList.size()) {
            BulletM d = (BulletM)((Object)bulletList.get(x));
            d.distanceTraveled += d.velocity;
            if (d.distanceTraveled > BulletM.myData.location.distance(d.fireLocation) + 50.0) {
                bulletList.remove(x);
                --x;
            }
            ++x;
        }
    }

    public static void removeOldBullets(AdvancedRobot b) {
        int x = 0;
        while (x < bulletList.size()) {
            BulletM d = (BulletM)((Object)bulletList.get(x));
            if (d.fireTime < b.getTime()) {
                bulletList.remove(x);
                --x;
            }
            ++x;
        }
    }

    public static void drawWave(AdvancedRobot bot) {
        Graphics2D g = bot.getGraphics();
        g.setColor(Color.red);
        int x = 0;
        while (x < bulletList.size()) {
            BulletM bulletData = (BulletM)((Object)bulletList.get(x));
            Point2D.Double loc = BulletM.project(bulletData.fireLocation, bulletData.directAngle, bulletData.distanceTraveled);
            if (bulletData.fireTime == bot.getTime()) {
                g.fillOval((int)(loc.x - 5.0), (int)(loc.y - 5.0), 10, 10);
            }
            ++x;
        }
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }
}

