/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.patterns;

import florent.XSeries.patterns.Control;
import florent.XSeries.patterns.KnowledgeSource;
import florent.XSeries.utils.RobocodeTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Blackboard<T extends KnowledgeSource> {
    private ArrayList<T> solutions = new ArrayList();
    private Control<T> control = new Control(this);
    private T bestSource;

    public void update() {
        this.solutions.clear();
        this.control.loop();
        Collections.sort(this.solutions);
        KnowledgeSource source = (KnowledgeSource)this.solutions.get(0);
        if (!source.equals(this.bestSource)) {
            RobocodeTools.log("Switching to " + source.getName());
            this.bestSource = source;
        }
    }

    public T inspect() {
        return this.bestSource;
    }

    public void attachKnowledgeSource(T source) {
        this.control.attachKnowledgeSource(source);
    }

    public void detachKnowledgeSource(T source) {
        this.control.detachKnowledgeSource(source);
    }

    public Iterator<T> sourceIterator() {
        return this.control.sourceIterator();
    }

    public void addSolution(KnowledgeSource source) {
        KnowledgeSource t = source;
        this.solutions.add(t);
    }
}

