/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.gun;

import eem.frame.bot.InfoBot;
import eem.frame.bot.botStatPoint;
import eem.frame.bot.fighterBot;
import eem.frame.gun.baseGun;
import eem.frame.gun.firingSolution;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.LinkedList;

public class guessFactorGun
extends baseGun {
    public guessFactorGun() {
        this.gunName = "guessFactorGun";
        this.color = new Color(255, 136, 255, 128);
    }

    @Override
    public LinkedList<firingSolution> getFiringSolutions(fighterBot fighterBot2, InfoBot infoBot, long l, double d) {
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        Point2D.Double double_ = fighterBot2.getMotion().getPositionAtTime(l);
        botStatPoint botStatPoint2 = infoBot.getStatClosestToTime(l - 1L);
        if (botStatPoint2 == null) {
            return linkedList;
        }
        double d2 = botStatPoint2.getLateralSpeed(double_);
        double[] dArray = this.getRelevantGF(fighterBot2, infoBot);
        double d3 = this.getMostProbableGF(dArray) * (double)math.signNoZero(d2);
        double d4 = math.angle2pt(double_, botStatPoint2.getPosition());
        firingSolution firingSolution2 = new firingSolution((baseGun)this, double_, d4 += d3 * physics.calculateMEA(physics.bulletSpeed(d)), l, d);
        if (firingSolution2 == null) {
            return linkedList;
        }
        long l2 = l - botStatPoint2.getTime();
        if (l2 <= 0L) {
            firingSolution2.setQualityOfSolution(1.0);
        }
        if (l2 > 0L) {
            firingSolution2.setQualityOfSolution(Math.exp(l2 / 5L));
            logger.noise("time " + l + " target info is outdated by " + l2);
        }
        linkedList.add(firingSolution2);
        linkedList = this.setFiringBotName(fighterBot2.getName(), linkedList);
        linkedList = this.setTargetBotName(infoBot.getName(), linkedList);
        return linkedList;
    }

    protected double[] getRelevantGF(fighterBot fighterBot2, InfoBot infoBot) {
        return fighterBot2.getGunManager().getGuessFactors(infoBot.getName());
    }

    private double getMostProbableGF(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double d = 0.0;
        int n2 = 0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            if (!(dArray[i] > d2)) continue;
            d2 = dArray[i];
            n2 = i;
        }
        double d3 = d == 0.0 ? 0.0 : math.bin2gf(n2, n);
        return d3;
    }

    @Override
    public LinkedList<firingSolution> getFiringSolutions(InfoBot infoBot, InfoBot infoBot2, long l, double d) {
        logger.error("getFiringSolutions should not be called like this: ( InfoBot fBot, InfoBot tBot, long time, double bulletEnergy )");
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        return linkedList;
    }

    public LinkedList<firingSolution> getFiringSolutions(Point2D.Double double_, InfoBot infoBot, long l, double d) {
        logger.error("getFiringSolutions should not be called like this: ( Point2D.Double fPos, InfoBot tBot, long time, double bulletEnergy )");
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        return linkedList;
    }
}

