/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Angle
implements Continuum<Angle>,
AbsoluteToRelative<Angle, Angle> {
    private double degrees;

    public Angle(double degrees) {
        this.degrees = (double)Math.round(degrees * 1000000.0) / 1000000.0;
    }

    @Override
    public Angle negate() {
        return new Angle(-this.degrees);
    }

    @Override
    public Angle add(Angle angle) {
        return new Angle(this.degrees + angle.degrees);
    }

    @Override
    public Angle add(double degrees) {
        return new Angle(this.degrees + degrees);
    }

    @Override
    public Angle subtract(Angle angle) {
        return new Angle(this.degrees - angle.degrees);
    }

    @Override
    public Angle subtract(double degrees) {
        return new Angle(this.degrees - degrees);
    }

    @Override
    public Angle multiply(double scalar) {
        return new Angle(this.degrees * scalar);
    }

    @Override
    public Angle divide(double d) {
        return new Angle(this.degrees / d);
    }

    @Override
    public double divide(Angle d) {
        return this.degrees / d.degrees;
    }

    public double toDegrees() {
        return this.degrees;
    }

    public double toRadians() {
        return Math.toRadians(this.degrees);
    }

    @Override
    public double toDouble() {
        return this.degrees;
    }

    public String toString() {
        return String.valueOf(Long.toString(Math.round(this.degrees))) + "d";
    }

    public String toStringRadians() {
        return String.valueOf(Long.toString(Math.round(this.toRadians()))) + "r";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Angle angle = (Angle)o;
            return angle.degrees == this.degrees;
        }
        return result;
    }

    public int hashCode() {
        return new Double(this.degrees).hashCode();
    }
}

