/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.DynamicHeading;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticHeadingImpl;

public class DynamicHeadingImpl
implements DynamicHeading {
    private StaticHeading heading;
    private StaticHeading target;

    public DynamicHeadingImpl(double newHeading) {
        this.setHeading(newHeading);
        this.setAbsoluteTargetHeading(newHeading);
    }

    public DynamicHeadingImpl(StaticHeading newHeading) {
        this.setHeading(newHeading);
        this.setAbsoluteTargetHeading(newHeading);
    }

    public StaticHeading getStaticHeading() {
        return this.heading;
    }

    public void setHeading(double newHeading) {
        this.heading = new StaticHeadingImpl(newHeading);
    }

    public void setHeading(StaticHeading newHeading) {
        this.heading = new StaticHeadingImpl(newHeading);
    }

    public void setAbsoluteTargetHeading(double newHeading) {
        this.target = new StaticHeadingImpl(newHeading);
    }

    public void setAbsoluteTargetHeading(StaticHeading newHeading) {
        this.target = new StaticHeadingImpl(newHeading);
    }

    public void setRelativeTargetHeading(double other) {
        this.setAbsoluteTargetHeading(this.heading.getCompoundAngle(other));
    }

    public void setRelativeTargetHeading(StaticHeading other) {
        this.setAbsoluteTargetHeading(this.heading.getCompoundAngle(other));
    }

    public double projectHeading(double maxTurnRate) {
        double relativeHeadingChange = this.getRelativeAngle(this.target);
        relativeHeadingChange = Constraints.getClosestLegalTurnRate(relativeHeadingChange, maxTurnRate);
        return this.heading.getCompoundAngle(relativeHeadingChange);
    }

    public void debug() {
        Debug.debug("Dynamic heading: " + this.getHeading());
        Debug.debug("Target heading: " + this.target.getHeading());
    }

    public double getHeading() {
        return this.heading.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.heading.equalsAngle(other);
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.heading.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.heading.getRelativeAngle(other);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.heading.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.heading.getCompoundAngle(other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return this.heading.getCompoundAngle(other);
    }
}

