/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;

public class StaticPositionImpl
implements StaticPosition {
    private final double x;
    private final double y;

    public StaticPositionImpl(double newX, double newY) {
        this.x = newX;
        this.y = newY;
    }

    public StaticPositionImpl(StaticPosition other) {
        this.x = other.getX();
        this.y = other.getY();
    }

    public StaticPositionImpl(StaticPosition origin, StaticPosition offset) {
        this.x = origin.getX() + offset.getX();
        this.y = origin.getY() + offset.getY();
    }

    public StaticPositionImpl(StaticPosition origin, double angle, double distance) {
        this.x = origin.getX() + Math.sin(angle) * distance;
        this.y = origin.getY() + Math.cos(angle) * distance;
    }

    public StaticPositionImpl(StaticPosition origin, StaticVector vector) {
        this.x = origin.getX() + Math.sin(vector.getHeading()) * vector.getVelocity();
        this.y = origin.getY() + Math.cos(vector.getHeading()) * vector.getVelocity();
    }

    public StaticPositionImpl(StaticVector vector) {
        this.x = Math.sin(vector.getHeading()) * vector.getVelocity();
        this.y = Math.cos(vector.getHeading()) * vector.getVelocity();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean equalsPosition(StaticPosition other) {
        return Constraints.isApproximatelyZero(this.getDistance(other));
    }

    public double getDistance(StaticPosition other) {
        return StaticPositionImpl.getAbsDistance(other.getX() - this.getX(), other.getY() - this.getY());
    }

    public double getBearing(StaticPosition other) {
        return StaticPositionImpl.getBearing(other.getX() - this.getX(), other.getY() - this.getY());
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return new StaticPositionImpl(other.getX() - this.x, other.getY() - this.y);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return new StaticVectorImpl(this.getBearing(other), this.getDistance(other));
    }

    public static double getBearing(double deltaX, double deltaY) {
        double bearing = 0.0;
        if (deltaY == 0.0) {
            bearing = deltaX < 0.0 ? 4.71238898038469 : 1.5707963267948966;
        } else {
            bearing = Math.atan(deltaX / deltaY);
            if (deltaY < 0.0) {
                bearing += Math.PI;
            }
        }
        return Constraints.getZeroToTwoPi(bearing);
    }

    public static double getAbsDistance(double deltaX, double deltaY) {
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public void debug() {
        Debug.debug("Static position: ( " + Debug.trim(this.x) + ", " + Debug.trim(this.y) + " )");
    }
}

