package lmk;
import robocode.*;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import static robocode.util.Utils.normalRelativeAngleDegrees;
import static robocode.Rules.getBulletSpeed;
import static robocode.util.Utils.normalRelativeAngle;
import robocode.util.Utils;
import java.awt.*;
import java.util.List;
import java.util.*;

//import java.awt.Color;

/**
 * ACPFinal - a robot by (your name here)
 */
public class ACPFinal extends AdvancedRobot
{
        int count = 0;
        double gunTurnAmt; 
		int dir = 1;
		long fire_time = -1;
        String trackName;
		List<double[]> gravity_Repulses; // A list of [x,y,strength]'s
		List<GravityRepulseLine> gravity_Repulse_Lines;

		List<BulletTracker> enemy_bullets; // A list of the enemy's bullets
		double enemy_last_energy; // Their last known energy
		long enemy_last_spottime; // Last time we spotted them

		ArrayList<EnemyPredictor> enemy_predictors;

		public double[] gravityForce(double x, double y) {
			double[] f = new double[2];
			Iterator it = gravity_Repulses.iterator();
			while (it.hasNext()) {
				double[] value = (double[])it.next();
				double dx = x - value[0];
				double dy = y - value[1];
				double strength = value[2] / Math.sqrt(dx*dx+dy*dy);
				double dir = Math.atan2(dy, dx);
				f[0] += strength * 100.0 * Math.cos(dir);
				f[1] += strength * 100.0 * Math.sin(dir);
				//System.out.printf("repulse: dx=%.2f dy=%.2f (%.2f,%.2f) f=<%.2f,%.2f>\n", dx, dy, value[0], value[1], f[0], f[1]);
			}
		
			for (GravityRepulseLine g: gravity_Repulse_Lines) {
				f[0] += g.getForceX(x,y) * 100.0;
				f[1] += g.getForceY(x,y) * 100.0;
				System.out.printf("line: %.2f,%.2f\n", g.getForceX(x,y)*100.0, g.getForceY(x,y)*100.0);
			}

			// Add in the walls as repulses
			f[0] += 100.0 / (x*x);
			f[0] -= 100.0 / ((getBattleFieldWidth() - x)*(getBattleFieldWidth() - x));
			f[1] += 100.0 / (y*y);
			f[1] -= 100.0 / ((getBattleFieldHeight() - y)*(getBattleFieldHeight() - y));
			//f[0] = 1.0;
			//f[1] = 0.0;
			
			System.out.printf("f=<%.2f,%.2f>\n", f[0], f[1]);
			
			return f;
		}

		public void gravityAddRepulse(double x, double y, double strength) {
			double[] value = new double[3];
			value[0] = x;
			value[1] = y;
			value[2] = strength;
			gravity_Repulses.add(value);
		}

		public void gravityAddRepulseLine(GravityRepulseLine g) {
			gravity_Repulse_Lines.add(g);
		}
	
		public void gravityClearRepulses() {
			gravity_Repulses.clear();
			gravity_Repulse_Lines.clear();
		}

		// If constrain is true, then motion will be limited to ONLY in the
		// optimal direction. If false, then we'll start moving ASAP.
		public void gravityRun(boolean constrain) {
			double[] gravity_field = gravityForce(getX(), getY());
			//setTurnLeft(10.0);
			double gravity_dir = Math.toDegrees(Math.atan2(gravity_field[1], -gravity_field[0]))-90.0;
			double gravity_strength = Math.sqrt(gravity_field[0]*gravity_field[0] + gravity_field[1]*gravity_field[1]);
			//gravity_dir = 90.0;
			//gravity_strength = 1.0;
			double gravity_bearing = Math.toDegrees(Utils.normalRelativeAngle(Math.toRadians(gravity_dir - getHeading())));
			//System.out.printf("%.2f,%.2f,hdg=%.2f => %.2f,%.2f => %.2fdeg (bearing=%.2f)\n", getX(), getY(), getHeading(), gravity_field[0], gravity_field[1], gravity_dir, gravity_bearing);
			if (constrain) {
				setMaxVelocity(Rules.MAX_VELOCITY);
				if (Math.abs(gravity_bearing) < 2.0) {
					// Move in that direction
					setAhead(Double.POSITIVE_INFINITY);
				} else {
					setAhead(0.0);
				}
			} else {
				setMaxVelocity(Rules.MAX_VELOCITY * Math.cos(gravity_bearing));
				setAhead(Double.POSITIVE_INFINITY);
			}
			setTurnRight(gravity_bearing);
		}

        public void run() {
				setAdjustRadarForGunTurn(true);
				setAdjustGunForRobotTurn(true);
                setBodyColor(Color.black);
                setGunColor(Color.red);
                setRadarColor(Color.blue);
                setScanColor(Color.white);
                setBulletColor(Color.blue);

                trackName = null;
                gunTurnAmt = 10;
				gravity_Repulses = new ArrayList<double[]>();
				gravity_Repulse_Lines = new ArrayList<GravityRepulseLine>();
				enemy_bullets = new ArrayList<BulletTracker>();
				enemy_predictors = new ArrayList<EnemyPredictor>();
				enemy_predictors.add(new EnemyLinearPredictor(this));
			
				while (true) {
					turnRadarRightRadians(Double.POSITIVE_INFINITY);//turnRadarRight
					//gravityRun(true);
					execute();
				}
		}

		public double nearestWallDist() {
			double left = getX() - 0;
			double top = getY() - 0;
			double right = getWidth() - getX();
			double bottom = getHeight() - getY();
			if (left < top && left < right && left < bottom) return left;
			if (top < left && top < right && top < bottom) return top;
			if (right < left && right < top && right < bottom) return right;
			return bottom;
		}

		// Absolute heading
		public int nearestWallDir() {
			double left = getX() - 0;
			double top = getY() - 0;
			double right = getWidth() - getX();
			double bottom = getHeight() - getY();
			if (left < top && left < right && left < bottom) return 270;
			if (top < left && top < right && top < bottom) return 0;
			if (right < left && right < top && right < bottom) return 90;
			return 180;
		}

        public void onScannedRobot(ScannedRobotEvent e) {
			if (getTime() == fire_time) {
				setFire(5.0);
				fire_time = -1;
			}
			double absoluteBearing = getHeadingRadians() + e.getBearingRadians();//robot's absolute bearing
			double randomGuessFactor = (Math.random() - .5) * 2;
			double maxEscapeAngle = Math.asin(8.0/(20 - (3 *Math.min(3,getEnergy()/10))));//farthest the enemy can move in the amount of time it would take for a bullet to reach them
			double randomAngle = randomGuessFactor * maxEscapeAngle;//random firing angle
			double firingAngle = Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()+randomAngle/3);//amount to turn our gun
			//setTurnGunRightRadians(firingAngle);//Aim!
			//setFire(getEnergy()/10);//Fire, using less energy if we have low energy
			fire_time = getTime()+1;
			setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing-getRadarHeadingRadians()));//lock on the radar
			if(Math.random()>.9 || (nearestWallDist() < 100 && Math.random()>0.7)){
				// If we're close to a wall, then we want to move away
				if (nearestWallDist() < 100) {
					double tgt_heading = getHeading() + (-90-e.getBearingRadians()*dir);
					if (Math.abs(tgt_heading - nearestWallDir()) > 180.0) {
						dir = -dir;
					}
				} else {
					dir=-dir;//randomly changing move and turn direction
				}
			}

			for (EnemyPredictor ep: enemy_predictors) {
				ep.sighting(e);
			}

			// Estimate their future position @ the time a bullet would get to them
			double bullet_eta = e.getDistance() / getBulletSpeed(2.0);
			double tgt_rel_x = e.getDistance() * Math.cos(e.getBearingRadians());
			double tgt_rel_y = e.getDistance() * Math.sin(e.getBearingRadians());
			double rel_heading = -e.getHeadingRadians() + getHeadingRadians();
			double est_x = tgt_rel_x + bullet_eta * Math.cos(rel_heading) * e.getVelocity();
			double est_y = tgt_rel_y + -bullet_eta * Math.sin(rel_heading) * e.getVelocity();
			//est_x = tgt_rel_x;-

			while (true) {
				bullet_eta = Math.sqrt(est_x*est_x + est_y*est_y) / getBulletSpeed(2.0);
				tgt_rel_x = e.getDistance() * Math.cos(e.getBearingRadians());
				tgt_rel_y = e.getDistance() * Math.sin(e.getBearingRadians());
				rel_heading = -e.getHeadingRadians() + getHeadingRadians();
				est_x = tgt_rel_x + bullet_eta * Math.cos(rel_heading) * e.getVelocity();
				est_y = tgt_rel_y + -bullet_eta * Math.sin(rel_heading) * e.getVelocity();
				break;
			}

			//est_y = tgt_rel_y;
			double wanted_bearing = Math.atan2(est_y,est_x) + getHeadingRadians();//getHeadingRadians() + e.getBearingRadians();//Math.atan(est_y/est_x);
			wanted_bearing = enemy_predictors.get(0).optimalBearing(2.0);
			setTurnGunRightRadians(Utils.normalRelativeAngle(wanted_bearing/*+getHeadingRadians()*/-getGunHeadingRadians()));
			fire_time = getTime() + 1;

			double tgt_x = getX() + e.getDistance()*Math.sin(e.getBearingRadians()+getHeadingRadians());
			double tgt_y = getY() + e.getDistance()*Math.cos(e.getBearingRadians()+getHeadingRadians());

			/* Enemy bullet tracking code */
			Iterator<BulletTracker> it = enemy_bullets.iterator();
			while (it.hasNext()) {
				BulletTracker b = it.next();
				b.update(getTime());
				if (b.getX() < 0 || b.getY() < 0 || b.getX() > getBattleFieldWidth() || b.getY() > getBattleFieldHeight()) {
					// Delete it
					it.remove();
				}
			}

			/* Enemy tracking code (note: We only plan for one opponent) */
			long dt = getTime() - enemy_last_spottime;
			double denergy = -(e.getEnergy() - enemy_last_energy);
			if (denergy > 0.1 && denergy < 3.1) {
				// Let's assume they fired a bullet
				double bullet_hdg = e.getBearing() + getHeading() + 180.0; // Assume that they're firing directly at us
				BulletTracker b = new BulletTracker(tgt_x, tgt_y, bullet_hdg, denergy, getTime());
				enemy_bullets.add(b);
				System.out.printf("Bullet fired! dir=%.2f\n", bullet_hdg);
			}
			//System.out.printf("denergy=%.2f\n", denergy);
			enemy_last_spottime = getTime();
			enemy_last_energy = e.getEnergy();

			/* Now the driving code */
			//setAhead(100*Math.random()*dir);
			//setTurnLeftRadians(-90-e.getBearingRadians()*dir);//Turn perpendicular to them
			gravityClearRepulses();
			//System.out.printf("%.2f@%.2f => %.2f,%.2f\n",e.getDistance(), e.getBearing(), tgt_x,tgt_y);
			gravityAddRepulse(tgt_x, tgt_y, 1.0);

			// Add a repulse for every (estimated) bullet
			for (BulletTracker b: enemy_bullets) {
				gravityAddRepulse(b.getX(), b.getY(), -2.0);
				GravityRepulseLine l = new GravityRepulseLine(b.getX(), b.getY(), b.getDir(), 10.0);
				gravityAddRepulseLine(l);
				System.out.printf("Bullet: %f %f %f\n", b.getX(), b.getY(), b.getDir());
			}

			gravityRun(false);

			return;
		}

        public void onHitByBullet(HitByBulletEvent e)
        {
                /*back(100);
                turnLeft(100);
                back(100);
                //fire(2);
				scan();*/
        }

        public void onHitRobot(HitRobotEvent e) {
                if (trackName != null && !trackName.equals(e.getName())) {
                        out.println("Tracking " + e.getName() + " due to collision");
                }
                trackName = e.getName();
                gunTurnAmt = normalRelativeAngleDegrees(e.getBearing() + (getHeading() - getRadarHeading()));
                //turnGunRight(gunTurnAmt);
                fire(5);
                //back(50);
        }

        public void onWin(WinEvent e) {
                for (int i = 0; i < 50; i++) {
                        turnRight(30);
                        turnLeft(30);
                }
        }
}

// This class assumes the enemy isn't moving.
class EnemyPredictor
{
 	double bearing;
	AdvancedRobot robot;

	public EnemyPredictor(AdvancedRobot us) {
		robot = us;
	}

	public void sighting(ScannedRobotEvent e) {
		bearing = e.getBearing();
	}

	public double optimalBearing(double firepower) {
		return bearing;
	}
}

// Assumes the enemy moves linearly
class EnemyLinearPredictor extends EnemyPredictor
{
	double last_x;
	double last_y;
	double last_vel;
	double last_hdg;
	AdvancedRobot robot;

	public EnemyLinearPredictor(AdvancedRobot us) {
		super(us);
		robot = us;
	}

	public void sighting(ScannedRobotEvent e) {
		last_x = robot.getX() + e.getDistance()*Math.cos(e.getBearingRadians());
		last_y = robot.getY() + e.getDistance()*Math.sin(e.getBearingRadians());
		last_vel = e.getVelocity();
		last_hdg = e.getHeading();
	}

	public double optimalBearing(double firepower) {
		double dx = last_x - robot.getX();
		double dy = last_y - robot.getY();
		double dist = Math.sqrt(dx*dx+dy*dy);

		double bullet_eta = dist / getBulletSpeed(firepower);
		double tgt_rel_x = dist * Math.cos(Math.atan2(dy, dx));
		double tgt_rel_y = dist * Math.sin(Math.atan2(dy, dx));
		double rel_heading = -Math.toRadians(last_hdg) + robot.getHeadingRadians();
		double est_x = tgt_rel_x + bullet_eta * Math.cos(rel_heading) * last_vel;
		double est_y = tgt_rel_y + -bullet_eta * Math.sin(rel_heading) * last_vel;
		//est_x = tgt_rel_x;-

		while (true) {
			bullet_eta = Math.sqrt(est_x*est_x + est_y*est_y) / getBulletSpeed(firepower);
			tgt_rel_x = dist * Math.cos(Math.atan2(dy, dx));
			tgt_rel_y = dist * Math.sin(Math.atan2(dy, dx));
			rel_heading = -Math.toRadians(last_hdg) + robot.getHeadingRadians();
			est_x = tgt_rel_x + bullet_eta * Math.cos(rel_heading) * last_vel;
			est_y = tgt_rel_y + -bullet_eta * Math.sin(rel_heading) * last_vel;
			break;
		}

		//est_y = tgt_rel_y;
		double wanted_bearing = Math.atan2(est_y,est_x) + robot.getHeadingRadians();
		System.out.printf("%.2f\n", wanted_bearing);
		return wanted_bearing;
	}
}

class GravityRepulseLine
{
	public double x0;
	public double y0;
	public double dir;
	public double strength;
	public GravityRepulseLine(double x0, double y0, double dir, double strength) {
		this.x0 = x0;
		this.y0 = y0;
		this.dir = Math.toRadians(dir);
		this.strength = strength;
	}

	public double distFromLine(double x, double y) {
		double dir_to_p = Math.atan2(y-y0, x-x0);
		double dtheta = dir_to_p - dir;
		double dist = Math.sqrt((x-x0)*(x-x0) + (y-y0)*(y-y0)) * Math.sin(dtheta);
		//System.out.printf("Dist from line <%.2f,%.2f>@%.2f to %.2f,%.2f is %.2f\n", x0,y0,Math.toDegrees(dir), x,y, dist);
		return dist;
	}

	public double getForceX(double x, double y) {
		return -Math.cos(dir+3.14159265/4.0) * strength / (distFromLine(x,y)*distFromLine(x,y));
	}

	public double getForceY(double x, double y) {
		return -Math.sin(dir+3.14159265/4.0) * strength / (distFromLine(x,y*distFromLine(x,y)));
	}
}

class BulletTracker
{
	double x;
	double y;
	double dir;
	double energy;
	double velocity;
	long last_update_time;
	public BulletTracker(double x, double y, double dir, double energy, long time) {
		last_update_time = time;
		this.x = x;
		this.y = y;
		this.dir = normalRelativeAngle(Math.toRadians(90.0-dir));
		this.energy = energy;
		this.velocity = 20.0 - 3.0 * energy;
	}

	public void update(long cur_time) {
		long dt = cur_time - last_update_time;
		last_update_time = cur_time;
		x += velocity * Math.cos(dir);
		y += velocity * Math.sin(dir);
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public double getDir() {
		return Math.toDegrees(dir);
	}
}
