package ar.horizon.util;

import java.awt.geom.*;
import java.util.*;

/**
 * Keeps a log of {@link RobotRecording}s back a few ticks.
 * 
 * @author Aaron Rotenberg
 */
public class RobotLog {
	private static final int MAX_DEPTH = 3;

	private LinkedList<RobotRecording> log = new LinkedList<RobotRecording>();
	private Rectangle2D.Double fieldRectangle;

	public RobotLog(Rectangle2D.Double fieldRectangle) {
		this.fieldRectangle = fieldRectangle;
	}

	/**
	 * When a recording is added to the log, it is automatically updated with
	 * information derived from the previous tick's recording (see
	 * {@link RobotRecording#updateWithPreviousRecording}).
	 */
	public void addEntry(RobotRecording entry) {
		entry.updateWithPreviousRecording(getEntry(0), fieldRectangle);
		log.addFirst(entry);

		if (log.size() > MAX_DEPTH) {
			log.removeLast();
		}
	}

	public RobotRecording getEntry(int entriesBack) {
		if (entriesBack >= log.size()) {
			return null;
		} else {
			return log.get(entriesBack);
		}
	}
}
