/*
 * Sparky
 * Created June 10 2012
 * Nathan Flick
 */

package ngf.nano;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.HitWallEvent;
import robocode.util.Utils;

public class Sparky extends AdvancedRobot {
    
    private static final double ENEMY_FIREPOWER = 2.8;
    private static final double ENEMY_SPEED = 20 - 3 * ENEMY_FIREPOWER;
    private static final double ENEMY_RELOAD = 10 * (1 + ENEMY_FIREPOWER / 5);
    private static final double PREF_RANGE = ENEMY_SPEED * ENEMY_RELOAD;
    private static final double ORBIT_DIST = (Math.PI / 2) * PREF_RANGE;
    private static final int PATTERN_DEPTH = 28;
    private static final double MY_SPEED = 11.;
    private static final double MOV_FACTOR = 2. / Math.PI;
    private static final double MOV_MAG = 14.;
    
    private static String log = "                    65535131070196605262140327675393210458745524280";
    private static int orbitDir = 1;
    
    @Override
    public void run() {
		setAdjustGunForRobotTurn(true);
        setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
		double tBearing;
		int matchLen;
        double dist;
        int matchPos;
        int ticks;
        
        setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
        
        dist = orbitDir * MOV_MAG / Math.sin(e.getEnergy() * MOV_FACTOR);
        setTurnRightRadians(Math.signum(dist) * Utils.normalRelativeAngle((tBearing = e.getBearingRadians()) 
                + Math.signum(dist) * ORBIT_DIST / e.getDistance()));
        setAhead(dist);
        
        log = String.valueOf((char) (e.getVelocity() * Math.sin(e.getHeadingRadians() 
                - (tBearing += getHeadingRadians())))).concat(log);
        matchLen = PATTERN_DEPTH;
        while ((matchPos = log.indexOf(log.substring(0, matchLen--), 
                (ticks = (int) (e.getDistance() / MY_SPEED)))) < 0);
        do {
            tBearing += ((short) log.charAt(--matchPos)) / e.getDistance();
        } while (--ticks > 0);
        setTurnGunRightRadians(Utils.normalRelativeAngle(tBearing - getGunHeadingRadians()));
        setFire(e.getEnergy() / 4);
    }
    
    @Override
    public void onHitWall(HitWallEvent e) {
        orbitDir *= -1;
    }
    
}