//--------------------------------------------------------------------------
// $Id: Rectangle.java,v 1.1 2003/08/29 09:18:58 erning Exp $
//--------------------------------------------------------------------------
// Copyright (c) 2000-2003 Dragon Software Corp. All rights reserved.
//
// Please refer to COPYRIGHT for notices regarding the confidential
// and proprietary nature of this source code.
//--------------------------------------------------------------------------

package net.dragonsoft.robocoding.util;

public class Rectangle
{
    public Rectangle(double x1, double y1, double x2, double y2)
    {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean contains(double x, double y)
    {
        return (x >= x1 && y >= y1 && x <= x2 && y <= y2);
    }

    public boolean contains(Position p)
    {
        return contains(p.x, p.y);
    }

    public Position centerPosition()
    {
        double w = x2 - x1;
        double h = y2 - y1;
        return new Position(x1 + w, y1 + h);
    }

    public double getWidth()
    {
        return x2 - x1;
    }

    public double getHeight()
    {
        return y2 - y1;
    }

    public double x1 = 0;
    public double y1 = 0;
    public double x2 = 0;
    public double y2 = 0;
}
