/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;

/* Abstract movement class used as movement logic 
 * for robot
 */
public abstract class Movement
{
   /* this method is called every main loop tick to prepare orders
    * for robot elements, before performing their actions
    */
   public abstract void run();
   
   /*
    * event handlers
    * 
    * these are called on appropriate events that come to robot
    * and are redirected here for the movement strategy to decide what to do next;
    * default implementations do nothing
    */
   public void onHitRobot( HitRobotEvent e )
   {}
   
   public void onHitWall( HitWallEvent e )
   {}
   
   public void onHitByBullet( HitByBulletEvent e )
   {}
}