package romz.factory;

import romz.component.targeting.Targeting;
import romz.component.targeting.circular.CircularAcceleratedTargeting;
import romz.component.targeting.guessfactor.DistanceSegmentedGuessFactorTargeting;
import romz.component.targeting.historyanalysis.HistoryAnalysisTargeting;
import romz.component.targeting.nofire.NoFireTargeting;

public class TargetingFactory {

	public static Targeting getNoFireTargeting() {
		return new NoFireTargeting();
	}
	
	public static Targeting getCircularAcceleratedTargeting() {
		return new CircularAcceleratedTargeting();
	}
	
	public static Targeting getDistanceSegmentedGuessFactorTargeting() {
		return new DistanceSegmentedGuessFactorTargeting();
	}
	
	public static Targeting getHistoryAnalysisTargeting() {
		return new HistoryAnalysisTargeting();
	}
	
}
