package tobe;

import tobe.platform.*;
import tobe.movement.*;
import tobe.guns.*;
import tobe.util.*;
import tobe.statistics.*;
import robocode.*;
import java.awt.Color;

/**
 * Saturn - a robot by Torbjrn Gannholm
 * @version lambda
 * reengineered to use fusion framework and new sniper gun
 */
public class Saturn extends AdvancedRobot  {
  public void run() {
    setColors(new Color(190, 150, 255), Color.black, Color.red);
    setAdjustGunForRobotTurn(true);
    setAdjustRadarForGunTurn(true);
    if ( cc == null )
      cc = new CommandCentre(this);
    else
      cc.reset();
    radarTarget = null;
    radarAngle = Math.toRadians(45);
    while ( getTime() < 5 && !cc.allOppsSeen() ) {
      //check things out
      setTurnRight(360);
      setAhead(0);
      setTurnGunRight(360);
      setTurnRadarRight(360);
      execute();
    }
    while ( true ) {
      cc.tick();
      double x = getX();
      double y = getY();
      double time = getTime();
      movementTime[m] += 1;
      if ( getOthers() == 0 )
        victory.go(cc);
      else {
        //move
        movements[m].go(cc);
        //fire
        TargetStatistics target = cc.getPreferredTarget();
        Aim a = null;
        if ( target != null ) {
          int g = -1;
          if(target.getEnergy() == 0) {
            a = mercy.aim(cc);
          } else {
            g = chooseGun();
            a = guns[g].aim(cc);
          }
          if ( a != null ) {
            double gunTurn = BearingVector.normalizeAngle(a.bearing - getGunHeadingRadians());
            setTurnGunRightRadians(gunTurn);
            if ( Math.abs(gunTurn) < a.tolerance ) {
              double v = 20 - 3 * a.power;
              java.util.Iterator i = cc.getTargetStatisticsIterator();
              while ( i.hasNext() ) {
                TargetStatistics t = (TargetStatistics)i.next();
                if ( t.isSeen() )
                  addCustomEvent(new EvasionCondition(this, t.getName(), t.getDistance(x,y) / v + time - t.getTime(), t.getTime(), t.getHeading(), t.getAverageVelocity(), t.getX(), t.getY()));
              }
              if(g >= 0) guns[g].reset();
              Bullet b = setFireBullet(a.power);
              //out.println("firing "+g);
              if ( b == null )
                fireShot = false;
              else {
                fireShot = true;
                if(g >= 0) addCustomEvent(new GunControlCondition(b, g));
                if(target.getEnergy() == 0) target.mercyGiven();
              }
            }
            else
              fireShot = false;
          //gun not in tolerance
          }
          else
            fireShot = false;
        //no aim
        }
        else
          fireShot = false;
        //no target
        radarControl(fireShot || getGunHeat() / getGunCoolingRate() > 10 || a == null);
        execute();
      }
    }
  }

  TargetStatistics radarTarget;

  double radarAngle = Math.toRadians(45);

  private void radarControl(boolean mayUseGun) {
    if ( !(radarTarget != null && radarTarget.isSeen() && radarTarget.getTime() + 1 < getTime()) ) {
      radarTarget = cc.getPreferredScanTarget();
      if ( radarTarget == null || !radarTarget.isSeen() )
        radarAngle = Math.toRadians(45);
      else {
        double preferredBearing = radarTarget.getBearing(getX(), getY());
        radarAngle = BearingVector.normalizeAngle(preferredBearing - getRadarHeadingRadians());
        if ( radarAngle < 0 )
          radarAngle -= Math.toRadians(45);
        else
          radarAngle += Math.toRadians(45);
      }
    }
    setTurnRadarRightRadians(radarAngle);
    if ( mayUseGun ) {
      double radarGunAngle = 0;
      if ( radarAngle < 0 )
        radarGunAngle -= Math.toRadians(20);
      else
        radarGunAngle += Math.toRadians(20);
      setTurnGunRightRadians(radarGunAngle);
    }
  }

  /**
	 * onScannedRobot: What to do when you see another robot
	 */
  public void onScannedRobot(ScannedRobotEvent e) {
    cc.digestScan(e, fireShot);
  }

  public void onCustomEvent(CustomEvent e) {
    Condition c = e.getCondition();
    if ( c.getName().equals("EvasionCondition") ) {
      removeCustomEvent(c);
      cc.addEvasion((EvasionCondition)c);
    }
    else
      if ( c.getName().equals("GunControl") ) {
        removeCustomEvent(c);
        int g = ((GunControlCondition)c).gun;
        Bullet b = ((GunControlCondition)c).bullet;
        gunEfficiency[g] -= b.getPower();
        if ( b.getVictim() != null ) {
          //I hit one! Add damage done and my energy bonus
          gunEfficiency[g] += 7 * b.getPower();
          if ( b.getPower() > 1 )
            gunEfficiency[g] += 2 * (b.getPower() - 1);
        }
      }
  }

  public void onRobotDeath(RobotDeathEvent e) {
    cc.robotDied(e.getName());
  }

  public void onDeath(DeathEvent e) {
  //cc.save();
  }

  public void onWin(WinEvent e) {
  //cc.save();
  }

  public void onSkippedTurn(SkippedTurnEvent e) {
    out.println("Taking too long....");
  }

  public void onHitByBullet(HitByBulletEvent e) {
    movementDamage[m] += 4 * e.getPower();
    if ( e.getPower() > 1 )
      movementDamage[m] += 2 * e.getPower();
    m = chooseMovement();
    movements[m].init(cc);
  //out.println("moving "+m);
  }

  private class GunControlCondition extends Condition  {
    GunControlCondition(Bullet b, int g) {
      super("GunControl");
      bullet = b;
      gun = g;
    }

    public boolean test() {
      return !bullet.isActive();
    }

    public Bullet bullet;

    public int gun;
  }

  //TODO: all statics should probably be saved in a file, per target and/or situation
  //guns
  static Gun mercy = new MercyShot();

  static Gun sniper = new Sniper();

  //this stuff should be different for each target
  //and for each type of situation
  static Gun[] guns = { sniper };

  static double[] gunEfficiency = new double[guns.length];

  int chooseGun() {
    double min = Double.POSITIVE_INFINITY;
    for ( int i = 0; i < guns.length; i++) {
      min = Math.min(min, gunEfficiency[i] - 1);
    }
    double total = 0;
    for ( int i = 0; i < guns.length; i++) {
      total += gunEfficiency[i] - min;
    }
    double d = random.nextDouble() * total;
    for ( int i = 0; i < guns.length; i++) {
      d -= gunEfficiency[i] - min;
      if ( d < 0 )
        return i;
    }
    out.println("default gun");
    return 0;
  //just for safety's sake
  //perhaps I should have a null gun to use when firing does not pay?
  //but how do I then start firing again? Do I need to?
  }

  //movements
  static Movement victory = new Victory();

  static Movement secant = new Secant_w();

  //this stuff should be different for each target
  //and for each type of situation
  static Movement[] movements = { secant };

  static double[] movementTime = new double[movements.length];

  static double[] movementDamage = new double[movements.length];

  int chooseMovement() {
    double sum = 0;
    for ( int i = 0; i < movements.length; i++)
      sum += movementDamage[i] / Math.max(0.00001, movementTime[i]);
    double total = 0;
    for ( int i = 0; i < movements.length; i++)
      total += sum - movementDamage[i] / Math.max(0.00001, movementTime[i]);
    double d = random.nextDouble() * total;
    for ( int i = 0; i < guns.length; i++) {
      d -= sum - movementDamage[i] / Math.max(0.00001, movementTime[i]);
      if ( d < 0 )
        return i;
    }
    return 0;
  //just for safety's sake
  }

  static CommandCentre cc;

  int m = 0;

  boolean fireShot = false;

  java.util.Random random = new java.util.Random();
}
