package ntc.slippery;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.geom.*;
import java.awt.Color;

public class Leader2 extends TeamRobot
{
	
	public void run(){
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Utils.normalRelativeAngle(Math.toRadians(90)-getRadarHeadingRadians()));
		setTurnRightRadians(Utils.normalRelativeAngle(Math.toRadians(90)-getHeadingRadians()));
		setAhead(5000);		
		execute();		
		setBulletColor(Color.YELLOW);
		while(true){
			turnRadarRightRadians(Math.PI);
			turnRadarLeftRadians(Math.PI);	
		}
	}

	public void onScannedRobot(ScannedRobotEvent e){
		if(isTeammate(e.getName())){ return; }
		double enemyBearing = getHeadingRadians() + e.getBearingRadians();
		double x = getX() + e.getDistance() * Math.sin(enemyBearing);
		double y = getY() + e.getDistance() * Math.cos(enemyBearing);

		try{
			broadcastMessage(new Point2D.Double(x,y));
		}catch(IOException exc){
			out.println("Broadcasting error:" + e);
		}
	
		if(getEnergy()>10 && getGunTurnRemaining()<5){
			setTurnGunRightRadians(Utils.normalRelativeAngle(TeamDroid.absoluteBearing(new Point2D.Double(getX(),getY()),new Point2D.Double(x,y))-getGunHeadingRadians()));
			setFire(Math.min(e.getEnergy()/3,getEnergy()/10));
		}
	}
	
	public void onHitWall(HitWallEvent e){
		turnRightRadians(Math.PI/2);
		turnRadarRightRadians(Math.PI/2);
		setAhead(5000);
		execute();
	}
	
	public void onHitRobot(HitRobotEvent e){
		turnRightRadians(Math.PI/2);
		turnRadarRightRadians(Math.PI/2);
		setAhead(5000);
		execute();
	}

	public void onRobotDeath(RobotDeathEvent e){
		out.print(e.getName() + " died ");
		if(isTeammate(e.getName())){
			out.println(":(");
		}else{
			out.println(":)");
		}
	}

}