package doka;

import robocode.*;
import robocode.util.*;
import java.awt.*;
import java.awt.geom.*;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

public class Test extends AdvancedRobot
{
	private double limit(double a, double min, double max){
		return Math.min(max, Math.max(min, a));
	}

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.black,Color.black,Color.black,Color.red,Color.pink); // body,gun,radar,bullet,scanarc

		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		// Robot main loop
		while(true) {

			scan();
			execute();
		}
	}

	int dir = 1;

	/**
	 * onScannedRobot: What to do when you see another robot
	 */

	static double prevEnergy = 100.0;

	public void onScannedRobot(ScannedRobotEvent e) {
		//radar lock
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
 		setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle(radarTurn));
		
 		//targeting
		double bulletPower = 2.0;
		// double bulletPower = Math.max(0.1,Math.random() * 3.0);
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
	    
	    double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
	    
	    double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
		double randomAimOffset = -escapeAngle + Math.random() * 2 * escapeAngle;
	    setTurnGunRightRadians(Utils.normalRelativeAngle(headOnBearing + randomAimOffset - getGunHeadingRadians()));
	    // setTurnGunRightRadians(Utils.normalRelativeAngle(linearBearing - getGunHeadingRadians()));
	    // setTurnGunRightRadians(Utils.normalRelativeAngle(headOnBearing - getGunHeadingRadians()));

 		//fire
		if (getGunHeat() == 0 && Math.abs(getGunTurnRemaining()) < 36/2)
			setFire(bulletPower);

		// movement
		if((int)(Math.random()*20) == 0){
			dir *= -1;
		}
		// if((int)(Math.random()*20) == 0){
		// 	setMaxVelocity(Math.random()*8+4);
		// }

		// if(getDistanceRemaining()==0.0 && prevEnergy-e.getEnergy()>0.0){
	 //    	setAhead(36*direction);
	 //  	}
	 //  	prevEnergy = e.getEnergy();

		// double moveoffset = limit( ((300 - e.getDistance()) / 200) * 90*Math.PI/180, -60*Math.PI/180, 60*Math.PI/180);
		// double moveoffset = (e.getDistance() < 200) ? 40*Math.PI/180 : 0;
		// double moveoffset = 10*Math.PI/180;
		double moveoffset = (e.getDistance() < 200) ? 40*Math.PI/180 : 10*Math.PI/180;


		double moveangle = getHeadingRadians() + e.getBearingRadians() - dir*(90*Math.PI/180 + moveoffset);

		double traveldist = 0;
		double dEnergy = prevEnergy-e.getEnergy();
		if(getDistanceRemaining() == 0.0 && dEnergy > 0 && dEnergy <= 3.0){
		 	traveldist = ((3 + (int)(dEnergy*1.999999)) << 3 );
		}
		prevEnergy = e.getEnergy();

		//wall smoothing
		double stick = 120;
		Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		while (!fieldRect.contains(getX()+Math.sin(moveangle)*stick, getY()+ Math.cos(moveangle)*stick))
		{
			moveangle += dir*.1;	//turn a little toward enemy and try again
		}

		double turn = Utils.normalRelativeAngle(moveangle-getHeadingRadians());
		if (Math.abs(turn) > Math.PI/2)
		{
			turn = Utils.normalRelativeAngle(turn + Math.PI);
			if(traveldist != 0)
				setBack(traveldist);
		}
		else{
			if(traveldist != 0)
				setAhead(traveldist);
		}

		setTurnRightRadians(turn);
	}


	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {

	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		// dir *= -1;
		System.out.print("Wall Hit\n");
	}	
}
