package pez.rumble;
import pez.rumble.pgun.*;
import pez.rumble.pmove.*;
import pez.rumble.utils.RobotPredictor;
import robocode.*;
import robocode.util.Utils;

import java.awt.Color;

//Ali - by PEZ - Float like a butterfly. Sting like a bumble-bee.
//
//This code is released under the RoboWiki Public Code Licence (RWPCL), datailed on:
//http://robowiki.net/?RWPCL
//(Basically it means you must keep your code public if you use mine.)
//
//$Id: Ali.java,v 1.4 2006/05/04 05:18:27 peter Exp $

public class Ali extends AdvancedRobot {
	static double wins;
	static int skipped;

	boolean isTC = false; // http://robowiki.net/?TargetingChallenge
	boolean isMC = false; // http://robowiki.net/?MovementChallenge
	boolean doGL = false; // http://robowiki.net/?RobocodeGL
	
	Butterfly floater;
	BumbleBee stinger;
	RobotPredictor robotPredictor = new RobotPredictor();
	int timeSinceScan = 0;
	ScannedRobotEvent lastScanEvent;
	
	public void run() {
		BumbleBee.isTC = isTC;
		BumbleBee.doGL = doGL;
		Butterfly.isMC = isMC;
		floater = new Butterfly(this);
		stinger = new BumbleBee(this, robotPredictor);
		
		setColors(new Color(90, 55, 55), Color.black, Color.red);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		do {
			if (timeSinceScan++ > 1) {
				setTurnRadarRightRadians(Double.POSITIVE_INFINITY); 
			}
			if (getOthers() == 0 && timeSinceScan > 5) {
				onScannedRobot(lastScanEvent);
			}
			execute();
		} while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		lastScanEvent = e;
		timeSinceScan = 0;
		setTurnRadarRightRadians(Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians()) * 2);
		if (!isTC) {
			floater.onScannedRobot(e);
		}
		if (!isMC) {
			stinger.onScannedRobot(e);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		floater.onHitByBullet(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		floater.onBulletHit(e);
		stinger.onBulletHit(e);
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		floater.onBulletHitBullet(e);
	}
	
	public void onDeath(DeathEvent e) {
		stinger.roundOver();
	}
	
	public void onWin(WinEvent e) {
		wins++;
		stinger.roundOver();
	}

	public void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("skipped turn! time = " + getTime());
		skipped++;
	}
	
	public void setTurnRightRadians(double turn) {
		super.setTurnRightRadians(turn);
		robotPredictor.setTurnRightRadians(turn);
	}

	public void setAhead(double d) {
		super.setAhead(d);
		robotPredictor.setAhead(d);
	}

	public void setMaxVelocity(double v) {
		super.setMaxVelocity(v);
		robotPredictor.setMaxVelocity(v);
	}
}
