package rc.yoda.plugin;

import robocode.*;
import java.awt.Graphics2D;

/** 
 * Plugin - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Plugin.java : v1.0 -- 2007/05/12
 */


/**
 * Plugin is an interface that defines basic
 * interactions between a robot and any 
 * implementing Plugin
 *
 * @author Robert Codd
 * @version v1.0
 */
public interface Plugin
{	
	/**
	 * Event method called by this robot when it detects
	 * that the enemy fired a bullet
	 *
	 * @param double deltaEnergy the power of the bullet fired
	 */
	public void onRobotFire(double deltaEnergy); 
	
	/**
	 * Event method called by Robocode when this robot's scanner
	 * passes over another robot
	 * 
	 * @param ScannedRobotEvent information about the scanned robot
	 */	
	public void onScannedRobot(ScannedRobotEvent e);
	
	/**
	 * Event method called by Robocode when this robot
	 * gets hit by a bullet
	 * 
	 * @param HitByBulletEvent information about ther bullet
	 * that hit this robot
	 */	
	public void onHitByBullet(HitByBulletEvent e);
	
	/**
	 * Event method called by Robocode when a bullet this
	 * robot fired hits another robot
	 * 
	 * @param BulletHitEvent information about the robot 
	 * that got hit by the bullet
	 */		
	public void onBulletHit(BulletHitEvent e);
	
	/**
	 * Event method called by Robocode when a bullet this
	 * robot fired hit a wall
	 *
	 * @param BulletMissedEvent information about the bullet
	 */	
	public void onBulletMissed(BulletMissedEvent e);
	
	/**
	 * Event method called by Robocode when a bullet this
	 * robot fired collides with a bullet fired by another robot
	 *
	 * @param BulletHitBulletEvent information about the bullets
	 */	
	public void onBulletHitBullet(BulletHitBulletEvent e);
	
	/**
	 * Event method called by Robocode when this robot hits a wall
	 * 
	 * @param HitWallEvent information about the wall
	 */	
	public void onHitWall(HitWallEvent e);
	
	/**
	 * Event method called by Robocode when this robot 
	 * collides with another robot
	 *
	 * @param HitRobotEvent information about the collision and 
	 * the other robot in the crash
	 */	
	public void onHitRobot(HitRobotEvent e);
	
	/**
	 * Event method called by Robocode when a robot dies
	 *
	 * @param RobotDeathEvent name of decaesed robot
	 */	
	public void onRobotDeath(RobotDeathEvent e);	
	
	/**
	 * Event method called by Robocode when this robot
	 * wins a round
	 *
	 * @param WinEvent
	 */	
	public void onWin(WinEvent e);
	
	/**
	 * Event method called by Robocode when this robot dies
	 *
	 * @param DeathEvent 
	 */	
	public void onDeath(DeathEvent e);
	
	/**
	 * Event method called by Robocode when this robot is
	 * allowed to draw debugging graphics to the screen
	 *
	 * @param Graphics2D graphics that provides drawing method for painting
	 */	
	public void onPaint(Graphics2D g);
}