
package trab.crusader;
import robocode.*;
//import java.awt.geom.Circle2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.Color;
//import robocode.robocodeGL.*;
//import robocode.robocodeGL.system.*;
import java.util.ArrayList;

import trab.utils.*;
import trab.intel.*;

public class CrusaderWheels extends Object
{
  static double roundNum = 0;

  AdvancedRobot robot;

  //ScannedRobotEvent lastScannedEvent;
  
  IntelligenceManager intel;

  MovementStatist statist;
  MovementManager moveManager;

  double dir; // 1 = counterclockwise, -1 = clockwise

  public CrusaderWheels(AdvancedRobot robot, IntelligenceManager intelManager ) {

    this.intel = intelManager;
    this.robot = robot;
    statist = new MovementStatist( intel );
    statist.robot = robot;
    
    moveManager = new MovementManager( intel );
  
    dir = Math.random() < 0.5 ? -1 : 1;
  }

  public void roundInit() {

    roundNum++;
    
    statist.initRound();
    
  }

  public void run() {
/*
    if ( robot.getOthers() == 0 && statist.wavesSize() == 0 )
      return;
  */  
    if ( intel.enemyFired(0) && robot.getOthers() > 0 ) {
      statist.fireRealWave();
    }
    
    //public Vector getMaxMovePathUntilWaveHits( Point2D robotPos, double heading, double velocity, double orbitDirection, Wave wave ) {
    //if ( statist.wavesSize() > 0 || true ) {
    if ( statist.wavesSize() > 0 || robot.getOthers() > 0 ) {
      
      if ( statist.wavesSize() > 0 )
        statist.updateWaves();
          
      MovementWave w;
      if ( statist.wavesSize() > 0 )
        w = statist.getWaveToHit( intel.getRobotPosition(0), 0 );
      else {
        w = new MovementWave( intel.getEnemyPosition(0), intel.getRobotPosition(0), 2, 1 );
      }
      
      ArrayList forwardPath = moveManager.getMaxMovePathUntilWaveHits
      ( 
        intel.getRobotPosition(0),
        intel.getRobotHeadingRadians(0),  
        intel.getRobotVelocity(0),
        dir,
        w
      );
      ArrayList backwardPath = moveManager.getMaxMovePathUntilWaveHits
      ( 
        intel.getRobotPosition(0),
        intel.getRobotHeadingRadians(0),  
        intel.getRobotVelocity(0),
        -dir,
        w
      );
      /* 
      Point2D p;
      robot.out.println( "Forward path: " );
      for ( int i = 0; i < forwardPath.size(); i++ ) {
        p = (Point2D)forwardPath.elementAt( i );
        robot.out.println( i + " [ " + Utils.sloppyRound( p.getX(), 0 ) + " ][ " + Utils.sloppyRound( p.getY(), 0 ) + " ]");
      }*/ 
      double forwardDanger = 0;
      double backwardDanger = 0;
      double danger;
      Point2D p;
      
      double bestFPoint = 9999;
      double bestBPoint = 9999;
      
      for ( int i = 0; i < forwardPath.size(); i++ ) {
        p = (Point2D)forwardPath.get( i );
        danger = statist.getStatsDanger( p, w );
        forwardDanger += danger;
        if ( danger < bestFPoint )
          bestFPoint = danger;
      
      }
      for ( int i = 0; i < backwardPath.size(); i++ ) {
        p = (Point2D)backwardPath.get( i );
        danger = statist.getStatsDanger( p, w );
        //robot.out.println( danger );
        backwardDanger += danger;
        if ( danger < bestBPoint )
          bestBPoint = danger;
      }
      
      
      forwardDanger /= (double)forwardPath.size();
      backwardDanger /= (double)backwardPath.size();
      //robot.out.println( forwardPath.size() + " :: " + forwardPath.size() );
      //robot.out.println( "Forward: " + Utils.sloppyRound(forwardDanger,4) + ", " + bestFPoint + " Backward: " + Utils.sloppyRound(backwardDanger,4) + ", " + bestBPoint );
      
      //robot.out.println( "Forward  : " + Utils.sloppyRound(forwardDanger,2) + "\tBackward : " + Utils.sloppyRound(backwardDanger,2) );
      //robot.out.println(  );
      
      /*
      if ( forwardDanger > backwardDanger ) {
        dir = -dir;
        //robot.out.println( "Changing direction." );
      }*/
      
      if ( bestBPoint == bestFPoint ) {
        if ( forwardDanger > backwardDanger )
          dir = -dir;
          //robot.out.println( "Changing direction." );
      } 
      else if ( bestBPoint < bestFPoint ) {
        dir = -dir;
        //robot.out.println( "Changing direction." );
      }
      
      
      // for gl
      //statist.grapher.drawPath( forwardPath, 1 );
      //statist.grapher.drawPath( backwardPath, -1 );
      //statist.grapher.endTick();
      
    }
    
    
    Point2D gotoPoint = moveManager.getGotoPoint( intel.getRobotPosition(0), intel.getEnemyPosition(0), dir );
    
    //gotoPoint = moveManager.wallSmooth( gotoPoint, intel.getRobotPosition(0), dir );
    goTo( gotoPoint );
    
    
    /*
    else if ( robot.getTime() > 30 )
      statist.fireVirtualWave();
    */
    
    /*
    
    foreach forwardpath.size()
      forwardDanger += statist.danger( forwardPath.elementAt(i) );
    
    MovementManager.getNextTickpos( robot, gotoPoint )
    
    statistManager.getDanger( nextTickPos );
    
    */
  }
  /*
  public void onScannedRobot() {

  }
  */
  public void onDeath( DeathEvent e ) {

		//printStats();
	}
  public void onWin( WinEvent e ) {

		//printStats();
	}
  public void printStats() {

  }

  public void onHitByBullet(HitByBulletEvent e) {
    //enemyEnergy += 3 * e.getBullet().getPower();
	}
	public void onBulletHit( BulletHitEvent e ) {
	  /*
	  double power = e.getBullet().getPower();
	  enemyEnergy -= 4 * power + Math.max(2 * power - 1, 0);
    */
  }
  public void onBulletHitBullet(BulletHitBulletEvent e) {

  }
  
  void goTo(Point2D destination) {
    
    double angle = Utils.normalRelativeAngle( Utils.absoluteBearing( intel.getRobotPosition(0), destination) - intel.getRobotHeadingRadians(0));
    double turnAngle = Math.atan(Math.tan(angle));
    
    robot.setTurnRightRadians(turnAngle);
    double ahead = intel.getRobotPosition(0).distance(destination) * (angle == turnAngle ? 1 : -1);
    
    robot.setAhead(  ahead * Math.pow(Math.cos(turnAngle),8) );
  }
}