package trab.intel;
import robocode.*;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import trab.utils.*;

public class IntelligenceManager {
  
  private ArrayList robotDataSets;
  private ArrayList enemyDataSets;
  
  private int historySize;
  private AdvancedRobot robot;
  
  Rectangle2D.Double battleField;
  final int WALL_MARGIN = 20;
  
  private int roundNum;
  
  public IntelligenceManager( AdvancedRobot robot_, int history_size ) {
    historySize = history_size;
    this.robot = robot_;
  
    robotDataSets = new ArrayList();
    enemyDataSets = new ArrayList();
    
    robotDataSets.ensureCapacity( 2000 );
    enemyDataSets.ensureCapacity( 2000 );
    
    battleField = new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN, 800-WALL_MARGIN*2, 600-WALL_MARGIN*2);
    roundNum = 0;
  }
  
  public void initRound() {
    roundNum++;
    deleteData();  
  }
  public final int getRound() {
    return roundNum;  
  }
  
  public void deleteData() {
    robotDataSets.clear();    
    enemyDataSets.clear();
  }
  
  // adds a new dataSet if one hasnt been added this turn
  private void doDataSetCheck() {
    if ( robotDataSets.size() == 0 || (getRobotTick(0) != robot.getTime()) )
      addNewDataSet();  
  }
  
  private void addNewDataSet() {
      long tick = robot.getTime();
      
      DataSet robotDataSet = new DataSet();
      robotDataSet.tick = tick;
      robotDataSets.add( 0, robotDataSet );
      if ( robotDataSets.size() > historySize )
        robotDataSets.remove( robotDataSets.size() - 1 );
  
      
      DataSet enemyDataSet = new DataSet();
      enemyDataSet.tick = tick;
      enemyDataSets.add( 0, enemyDataSet );
      if ( enemyDataSets.size() > historySize )
        enemyDataSets.remove( enemyDataSets.size() - 1 );
  
  }
  
  // should register the energyGained on robot too;
  public void addData( BulletHitEvent e ) { 
    
    doDataSetCheck();
    
    double power = e.getBullet().getPower();
	  
	  DataSet dataSet = (DataSet)enemyDataSets.get( 0 );
	  dataSet.damageTaken += 4 * power + Math.max(2 * power - 1, 0);
    dataSet.bulletHitPower = power;
  
  }
  
  public void addData( HitByBulletEvent e ) {
    
    doDataSetCheck();
    
    double power = e.getBullet().getPower();
    
    getEnemyDataSet(0).damageTaken -= -3 * power;
    //((DataSet)enemyDataSets.get( 0 )).damageTaken -= -3 * power;
    
    DataSet dataSet = getRobotDataSet(0);
    dataSet.damageTaken += 4 * power + Math.max(2 * power - 1, 0);
    dataSet.bulletHitPower = power;
       
  }
  
  public void addData( ScannedRobotEvent e ) {
    //
    //
    //
    doDataSetCheck();
    
    DataSet robotDataSet = getRobotDataSet(0);
    
    robotDataSet.tick = robot.getTime();
    robotDataSet.velocity = robot.getVelocity();
    robotDataSet.heading = robot.getHeadingRadians();
    robotDataSet.energy = robot.getEnergy();
    robotDataSet.position = new Point2D.Double( robot.getX(), robot.getY() );
    
    if ( robotDataSets.size() > 1 ) {
      robotDataSet.acceleration = robotDataSet.velocity - getRobotDataSet(1).velocity;
    }
    else {
      robotDataSet.acceleration = robotDataSet.velocity;
    }
    
    //
    //
    //
    DataSet enemyDataSet = getEnemyDataSet(0);
    
    enemyDataSet.tick = robot.getTime();
    enemyDataSet.velocity = e.getVelocity();
    enemyDataSet.heading = e.getHeadingRadians();
    enemyDataSet.energy = e.getEnergy();
    enemyDataSet.position = new Point2D.Double( robot.getX()+ Math.sin(robot.getHeadingRadians() + e.getBearingRadians()) * e.getDistance(),
                                                robot.getY()+ Math.cos(robot.getHeadingRadians() + e.getBearingRadians()) * e.getDistance() );
    
    if ( enemyFired(0) )
      enemyDataSet.bulletFiredPower = getEnemyEnergyDrop( 0 );
    else if ( enemyDataSets.size() > 1 )
      enemyDataSet.bulletFiredPower = getEnemyDataSet(1).bulletFiredPower;
                                                
    if ( enemyDataSets.size() > 1 ) {
      enemyDataSet.acceleration = Math.abs(enemyDataSet.velocity) - Math.abs(getEnemyDataSet(1).velocity);
    }
    else {
      enemyDataSet.acceleration = 0;
    }
  }
  
  // ticks = ticks back in time. 0 = most recent recording, -1/1 the second most recent recording.
  final DataSet getRobotDataSet( int ticks ) {
    if ( Math.abs(ticks) >= robotDataSets.size() )
      return null;
    
    return (DataSet)robotDataSets.get( Math.abs(ticks) );
  }
  final DataSet getEnemyDataSet( int ticks ) {
    if ( Math.abs(ticks) >= enemyDataSets.size() )
      return null;
    
    return (DataSet)enemyDataSets.get( Math.abs(ticks) );
  }
  
  
  // get methods
  
  //
  // robot
  //
  public final double getRobotTick( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.tick;
  }
  
  public final double getRobotVelocity( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.velocity;
  }
  public final double getRobotAcceleration( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.acceleration;
  }
  public final double getRobotHeadingRadians( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.heading;
  }
  public final double getRobotEnergy( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.energy;
  }
  public final Point2D getRobotPosition( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return null;
    
    return  set.position;
  }
  public final double getRobotBulletHitPower( int i ) {
    DataSet set = getRobotDataSet( i );
    if ( set == null )
      return 0;
    
    return  set.bulletHitPower;
  }
  public final boolean robotWasHit( int i ) {
      return getRobotBulletHitPower( i ) != 0;
  }
  
  public final double getRobotDistanceToEnemy( int i) {
    if ( robotDataSets.size() > i );
    return getRobotPosition(i).distance( getEnemyPosition( i ) );
  }
  
  //heading - absBearing
  public final double getRobotToEnemyBearing( int i )
  {
    if ( robotDataSets.size() <= i ) 
      return 0;
    //absBearing  
    
    return Utils.normalRelativeAngle( -getRobotHeadingRadians(i) + Utils.absoluteBearing( getRobotPosition(i), getEnemyPosition(i) ) );
  }
  public final double getEnemyToRobotBearing( int i )
  {
    if ( robotDataSets.size() <= i ) 
      return 0;
    //absBearing  
    
    return Utils.normalRelativeAngle( -getEnemyHeadingRadians(i) + Utils.absoluteBearing( getEnemyPosition(i), getRobotPosition(i) ) );
  }
  
  // counter clockwise = 1
  public double getRobotBearingDirection( int i ) { 
    if ( robotDataSets.size() < i+1 )
      return 1;
    
    double bearingDirection = Utils.absoluteBearing( getEnemyPosition(i+1), getRobotPosition(i) ) - Utils.absoluteBearing( getEnemyPosition(i+1), getRobotPosition(i+1) );
    return bearingDirection > 0 ? 1 : -1;
  }
  /*
  LateralVelocity: velocity * Math.sin(scannedRobotEvent?.getHeadingRadians() - scannedRobotEvent?.getBearingRadians?() + getHeadingRadians())
  */
  public double getRobotLateralVelocity( int i ) { 
    if ( robotDataSets.size() < i )
      return 0;
    
    double latVel = getRobotVelocity(i) * Math.sin( getRobotHeadingRadians(i) - getEnemyToRobotBearing(i) + getEnemyHeadingRadians(i) );
    
    return latVel;
  }
  
  
  //
  // enemy
  //
  public final double getEnemyTick( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.tick;
  }
  
  public final double getEnemyVelocity( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.velocity;
  }
  public final double getEnemyAcceleration( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.acceleration;
  }
  public final double getEnemyHeadingRadians( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.heading;
  }
  public final double getEnemyEnergy( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.energy;
  }
  public final double getEnemyDamageTaken( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;
    
    return  set.damageTaken;
  }
  public final Point2D getEnemyPosition( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return null;
    
    return  set.position;
  }
  public final double getEnemyEnergyDrop( int i ) {
    if ( i > enemyDataSets.size() )
      return Double.NaN;

    return getEnemyEnergy(1) - getEnemyEnergy(0) + getEnemyDamageTaken(0);  
  }
  
  public final double getEnemyFirePower( int i ) {
    DataSet set = getEnemyDataSet( i );
    if ( set == null )
      return Double.NaN;

    return set.bulletFiredPower;
  }
  
  
  public final boolean enemyFired( int i ) {
    return Utils.isSorted( 0.09999999999D, getEnemyEnergyDrop( i ), 3.00000001D );
    //return (0.1 <= getEnemyEnergyDrop(i)) && (getEnemyEnergyDrop( i ) <= 3);
    //return Utils.isSorted( 0.1D, getEnemyEnergyDrop( i )+getEnemyDamageTaken( i+1 ), 3.0D  );
  }
  
  public final boolean isOnBattleField( Point2D p ) {
    return battleField.contains(p);   
  }
  
  
  private class DataSet extends Object {
      
    // explicit data
    public long tick;
    public double velocity;
    public double heading;
    public Point2D.Double position;
    public double energy;
    public double damageTaken;
    public double bulletHitPower;
    public double bulletFiredPower;
    // implicit data 
    public double acceleration; // get from vel(0)-vel(1)

    public DataSet() {
      tick = 0;
      velocity =
      heading =
      energy =
      damageTaken = 0;  
      bulletHitPower = 0;
      bulletFiredPower = 2; // initialize to 2 for virtual waves
      position = new Point2D.Double();
    }
  }
}