package tobe.mini;
import robocode.*;
import java.awt.Color;

/**
 * Charon - a robot by Torbjrn Gannholm
 * features anti-gravity bullet dodging movement like Pluto
 *
 * @TODO if possible, add laser firing
 */
public class Charon extends AdvancedRobot
{
	public void run() {
    	setColors(new Color(190, 150, 255), Color.black, Color.red);
		setAdjustGunForRobotTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		target = null;
		while(true) {
			double d;
			double x = getX();
			double y = getY();
			double myHeading = getHeadingRadians();
			if(move < 0) myHeading = MicroVector.normalizeAngle(myHeading+Math.PI);
            //calculate the gravity
			//start with some anti-matter rocket fuel
            gravity.setPolar(myHeading + Math.PI,1,x,y);
			
			//anti-gravity from opps
			java.util.Iterator i = opps.values().iterator();
            while( i.hasNext() ) {
				MicroTarget t = (MicroTarget) i.next();
				t.ticks++;//t.time++;
				if(t.seen) {
					t.changeOrigin(x,y);
					gravity.add(t.theta, 1000.0/(t.r*t.r));
					//now the target selection code
					t.desirability = 1000/t.r - Math.abs(t.velocity*Math.sin(t.heading-t.theta));
					if(t.desirability > 0 && (target == null || t.desirability > target.desirability)) {
						target = t;
					}
				}
			}
			
			MicroVector b = new MicroVector();//for calculations
			//anti-gravity from bullets
			i = shrapnel.iterator();
			while( i.hasNext() ) {
				MicroVector s = (MicroVector) i.next();
				//move it on
				s.setOrigin(s.getToX(), s.getToY());
				b.setPoints(s.getToX(), s.getToY(), x,y);
				//MicroVector.normalizeAngle(b.theta - s.theta) is my position relative to bullets motion
				d = Math.abs(Math.PI/2 - MicroVector.normalizeAngle(b.theta - s.theta))-Math.PI/4;//get out of way if heading for me, don't move into it otherwise
				gravity.add(b.theta + d, 10000.0/(b.r*b.r));
				//remove shrapnel
				d = b.r;
				b.setPoints(s.origoX, s.origoY, x, y);
				if(d > b.r) i.remove();
            }

            //anti-gravity from walls
			double wallWeight = 1000*(1+shrapnel.size());
			b.setPoints(x,getBattleFieldHeight(),x,y);
			d = Math.max(1, b.r-getWidth());
            gravity.add(b.theta, wallWeight/(d*d*getOthers()));
            b.setPoints(x,0,x,y);
			d = Math.max(1, b.r-getWidth());
            gravity.add(b.theta, wallWeight/(d*d*getOthers()));
            b.setPoints(getBattleFieldWidth(),y,x,y);
			d = Math.max(1, b.r-getWidth());
            gravity.add(b.theta, wallWeight/(d*d*getOthers()));
            b.setPoints(0,y,x,y);
			d = Math.max(1, b.r-getWidth());
            gravity.add(b.theta, wallWeight/(d*d*getOthers()));

            d = MicroVector.normalizeAngle(gravity.theta-myHeading);
			if(Math.abs(d) < Math.PI/4) move = -move;
			else d = MicroVector.normalizeAngle(d+Math.PI);
            setTurnRightRadians(d);
            setAhead(move);
			setMaxVelocity(9*(Math.PI - Math.abs(d))/Math.PI);
			
			//aim and fire
			if(target != null) {
				double gunTurn = MicroVector.normalizeAngle(
					target.theta
					 //+ Math.atan((target.energy == 0 ? 0 : target.evasions[(int)(Math.random()*17)])*(target.time+target.r/(20-3*3))/target.r)
					 + Math.atan((target.energy == 0 ? 0 : target.evasions[(int)(Math.random()*17)])/(20-3*3))
					 - getGunHeadingRadians());
				setTurnGunRightRadians(gunTurn);
				fireBullet(target.energy == 0 ? 0 : 3);
			}
			
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		MicroTarget t = (MicroTarget) opps.get(e.getName());
		if( t == null ) {
			t = new MicroTarget();
			t.vl = new MicroTarget();
			//MicroVector linear = new MicroVector();
			//t.evasions.add(linear);
			t.ticks = 31;//to get the laser to start
			opps.put(e.getName(), t);
		}
		t.setPolar(e.getBearingRadians()+getHeadingRadians(), e.getDistance(), getX(), getY());
		//double energy = e.getEnergy();
		double power = t.energy - (t.energy = e.getEnergy());
		if( Math.abs(power - 1.55) <= 1.45 ) {//he fired
			MicroVector s = new MicroVector();
			s.setPolar(t.theta, -(20-3*power), t.getToX(), t.getToY());
			shrapnel.add(s);
			MicroVector l = new MicroVector();
			l.setPoints(t.origoX, t.origoY, t.getToX(), t.getToY());
			l.add(getHeadingRadians(), -getVelocity()*t.r/s.r);
			l.r = s.r;
			shrapnel.add(l);
		}
		//t.energy = energy;
		t.velocity = e.getVelocity();
		t.heading = e.getHeadingRadians();
		t.seen = true;
		//t.ticks += t.time;
		//t.time = 0;
		if( t.ticks > 28) {
			MicroTarget vl = t.vl;
			t.n = ++t.n % 17;
			power = vl.heading;//scan bearing when I started counting
			//how he moved
			vl.setPoints(t.getToX(), t.getToY(), vl.getToX(), vl.getToY());
			t.evasions[t.n] = vl.r*Math.sin(vl.heading - power)/t.ticks;//average move per tick
			//set up for next poll
			vl.heading = t.theta;//scan bearing to opp
			t.ticks = 0;
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		((MicroTarget) opps.get(e.getName())).seen = false;
		target = null;
	}
	
	MicroVector gravity = new MicroVector();
	double move = -1000000;
	static java.util.HashMap opps = new java.util.HashMap();
	static java.util.LinkedList shrapnel = new java.util.LinkedList();
	MicroTarget target;
}
