package shinh;

import robocode.*;

import java.awt.geom.Point2D;

public abstract class Move {
	public double evaluation = 100;
	public float usedTime = 0;
	public float damages = 0;

	protected Entangled ent;

	public float getAverageDamage() {
		return damages / usedTime * 60;
	}

	public String name() { return ""; }

	public void init() {
		ent = Entangled.me;
	}

	public boolean isValid() { return true; }

	public Move() {
		ent = Entangled.me;
	}
	abstract public void update();

	public void use() {}
	public void unuse() {}

	public void go() {
		usedTime++;
		update();
	}

	public void goRadian(double trans) {
		if (trans >= Const.PI_2) {
			ent.setBack(100);
			ent.setTurnRightRadians(trans-Const.PI);
		}
		else if (trans >= -Const.PI_2) {
			ent.setAhead(100);
			ent.setTurnRightRadians(trans);
		}
		else {
			ent.setBack(100);
			ent.setTurnRightRadians(Const.PI+trans);
		}
	}

	protected double distanceRateToWall(double x, double y, double r) {
		double vx = Math.sin(r);
		double vy = Math.cos(r);

		double wallX, wallY;

		if (r < Const.PI_2) {
			wallX = ent.fieldW;
			wallY = ent.fieldH;
		}
		else if (r < Const.PI) {
			wallX = ent.fieldW;
			wallY = 0;
		}
		else if (r < Const.PI3_2) {
			wallX = 0;
			wallY = 0;
		}
		else {
			wallX = 0;
			wallY = ent.fieldH;
		}

		double tx = Math.abs((wallX - x) / vx);
		double ty = Math.abs((wallY - y) / vy);

		return (tx < ty) ? tx : ty;
	}

	public void goPoint(Point2D.Double p) {
		double dx = p.x - ent.self.x;
		double dy = p.y - ent.self.y;
		double d = Util.length(dx, dy);

		double bearing = 
			Util.getNormalRadian(Math.atan2(dx, dy) - ent.getHeadingRadians());

		if (Math.abs(bearing) <= Const.PI_2) {
			ent.setTurnRightRadians(bearing);
			ent.setAhead(d);
		}
		else {
			if (bearing > 0) bearing -= Const.PI;
			else bearing += Const.PI;
			ent.setTurnRightRadians(bearing);
			ent.setBack(d);
		}
	}

}

