package bvh.fnr;

import robocode.*;
import java.awt.geom.Point2D;
//import java.util.*;
/**
 * Doel - deze class bevat zoveel mogelijk informatie over het doel:
 *
 * Deze class wordt gebruikt om gescande tegenstanders op te slaan en
 * om het huidig doel vast te leggen.
 *
 * to do: doel en kogel laten overerven van gemeenschappelijk "inkomend" object.
 */
class Doel implements Constanten {

/**********************************************************************
** definitie variabelen:
**********************************************************************/
// variabelen info opponent
   public  String               naam;
   public  Point2D.Double       positie, positie_o;
   public  double               v, v_o, vRot, richting, richting_o,
                                bewegingsrichting, bewegingsrichting_o,
                                e, e_o, afstand, afstand_o;
   public  double               deltaE, gemAfgelegdeWeg;
   public  long                 scanTijd, scanTijd_o;
   public  boolean              locked, patroonLocked;
   public  static double        vGem, afstandGem, correctieDoelhoek;

// variabelen patroonherkeninning
   public  double               rotatie[];
   public  double               snelheid[];
   public  StringBuffer         bewegingsPatroon;
   public  int                  scanTeller;
   private int                  zoekdiepte, sampleTijd = 5;

// variabelen statistiek Tegenstander
   private int[][]              treffers    = new int[6][4]; // 0,0=algemeen: 5 afstanden, 3 vermogens
   private int[][]              schoten     = new int[6][4];

// variabelen statistiek Bvh
   private int[][]              treffersBvh = new int[6][4];
   private int[][]              schotenBvh  = new int[6][4];

// variabelen statistiek patroonherkenning
   public  int                  probeerTeller, succesTeller, gemiddeldePatroonLengte;

/**********************************************************************
** Constructor:
**********************************************************************/
   public Doel() {
      naam        = null;
      locked      = false;
      positie     = new Point2D.Double(0,0);
      positie_o   = new Point2D.Double(0,0);
      e_o         = 100;

      if(rotatie == null) {
         rotatie  = new double[PATROONLENGTE];
         snelheid = new double[PATROONLENGTE];
         bewegingsPatroon = new StringBuffer();
      }
   }

/**********************************************************************
** methoden voor bijhouden info doel:
**********************************************************************/
/**
* Methode voor bijwerken doel-info:
*/
   public void setInfo(ScannedRobotEvent evt, Fenrir bot) {
      int    matchIndex;
      double transversaleBeweging, versnelling;
      long   deltaT;
      double patroon;

      naam                = evt.getName();
      if ( scanTijd == 0 )
         scanTijd         = bot.getTime();

      deltaT              = bot.getTime() - scanTijd;

      if ( deltaT < 10 )  locked = true;
      else                locked = false;
      sampleTijd          = (int) Math.round(0.99 * sampleTijd + 0.01 * deltaT);

      scanTijd            = bot.getTime();
      e                   = evt.getEnergy();
      v                   = evt.getVelocity();
      richting            = HulpRoutines.normaliseerRichting(bot.getHeadingRadians() + evt.getBearingRadians());
      afstand             = evt.getDistance();
      positie.x           = bot.getX() + afstand * Math.sin( richting );
      positie.y           = bot.getY() + afstand * Math.cos( richting );

// bepalen van de afgeleide waarden:
      versnelling         = (v-v_o)/(double)deltaT;
      vRot                = (evt.getHeadingRadians() - bewegingsrichting)
                           /(double)deltaT;
      bewegingsrichting   = evt.getHeadingRadians();
      deltaE              = Math.max(Math.min(e_o - e, 3D), 0D);

// bijhouden van de gemiddelde snelheid:
      if (v != 0) {
         if (v_o==0) vGem = 0; // gemiddelde snelheid resetten, omdat deze bij stop&go botjes
                               // vooral wordt bepaald door de wachttijd tussen stapjes.
         vGem             = 0.857 * vGem + 0.143 * v; // middelen over voorafgaande snelheden
      }
// bijhouden van de gemiddelde afstand:
      afstandGem          = 0.95 * afstandGem + 0.05 * afstand;

// afleiden of doel heeft geschoten:
      if ( deltaE >= 0.1 && deltaE <= 3.0 ) {
         Kogel  kogel;
         double richtingSchot;

         setSchoten();
         String id     = (String)(HulpRoutines.getNaamZonderVersie(naam)+"_"+scanTijd);
         // direct op mijn bot schieten heeft het meeste resultaat, dus aannemen
         // dat de tegenstander dat ook doet (is bovendien eenvoudiger)

         richtingSchot = richting_o + PI;
         // dan waarden van het doel doorgeven aan de kogel (let op: oude
         // doel.positie en doel.richting omdat kogel na de vorige scan
         // is afgevuurd):
         kogel = new Kogel(id+"_d", positie_o, scanTijd_o, deltaE, afstand, richtingSchot);
         bot.kogels.put(id+"_d", kogel);
      }

// bijwerken pattern matching code:
// - in 1-vs-1 is de sampleTijd gelijk 1 en hoeft er niets extras te worden gedaan
// - in melee modus moet onderscheid worden gemaakt tussen verwerking scans in
//   daadwerkelijke melee of eindstadium waar slechts 1 tegenstander resteerd. Omdat
//   radar in melee 360 graden spint en in 1-vs-1 gelocked blijft op het doel (ook
//   in melee mode), moet in de laatste situatie de scan slechts worden opgeslagen
//   als de sample tijd gelijk is aan die tijdens het 360 graden spinnen van de radar.

      if ( !bot.meleeModus
        || (bot.meleeModus && bot.getOthers() == 1 && scanTijd%sampleTijd == 1)
        || (bot.meleeModus && bot.getOthers()  > 1 )
         ) {

         transversaleBeweging  = v * Math.sin(bewegingsrichting - richting);
         patroon               = ((int)transversaleBeweging)|((int)versnelling<<8);

      // Vervolgens de transversale snelheid toevoegen aan het opgeslagen
      // bewegingspatroon van de tegenstander. 'Casten' naar een char zodat de
      // waarde kan worden opgeslagen op 1 positie.
         bewegingsPatroon.append((char)patroon);

      // teller is nu circulair: meest recente bewegingspatroon wordt bewaard:
      // - voordeel: meer dan pm 200 ronden mogelijk
      // - nadeel  : toch kennis verloren na herstart teller... hoe dit op te lossen?
         ++scanTeller;
         rotatie[scanTeller%PATROONLENGTE]  = HulpRoutines.normaliseerRichting(bewegingsrichting-bewegingsrichting_o);
         snelheid[scanTeller%PATROONLENGTE] = v;
      }

// bijwerken oude scan-waarden:
      positie_o           = positie;
      v_o                 = v;
      e_o                 = e;
      afstand_o           = afstand;
      richting_o          = richting;
      bewegingsrichting_o = bewegingsrichting;
   }

   public void setInfo(HitByBulletEvent evt, Fenrir bot)
   {
      naam                = evt.getName();
      locked              = true;
      scanTijd            = bot.getTime();
                            // Hodur zal de afname van energie meestal missen, maar deze is af te leiden...
      e                  -= (20-evt.getVelocity())/3D; // v=20-3*de <-> de=(20-v)/3;
      richting            = PI+evt.getHeadingRadians();
   }




/**
* Methode voor bijwerken doel-info:
* 2) info obv. inslag eigen kogel in de tegenstander
*/

   public void setInfo(BulletHitEvent evt, Fenrir bot)
   {
      Bullet kogel        = evt.getBullet();

      naam                = evt.getName();
      locked              = true;
      scanTijd            = bot.getTime();

      e                   = evt.getEnergy();
      richting            = kogel.getHeadingRadians();
      bewegingsrichting   = richting + HALFPI;
      positie.x           = kogel.getX();
      positie.y           = kogel.getY();
      afstand             = bot.huidigePositie.distance(positie);
   }



/**
* 3) info obv. botsing met tegenstander
*/

   public void setInfo(HitRobotEvent evt, Fenrir bot)
   {
      naam                = evt.getName();
      locked              = true;
      scanTijd            = bot.getTime();

      e                   = evt.getEnergy();
      richting            = bot.getHeadingRadians() + evt.getBearingRadians();
      bewegingsrichting   = richting + HALFPI;
      positie.x           = bot.getX() + 36D * Math.sin( richting );
      positie.y           = bot.getY() + 36D * Math.cos( richting );
      afstand             = bot.huidigePositie.distance(positie);
   }

/**********************************************************************
** methoden die positie doel bijhouden:
**********************************************************************/
/**
* Methoden schatten de x,y-waarden van het doel op tijd t o.b.v. de aanname
* dat het doel een lineaire beweging uitvoert.
*/
   public double xt(long t) {return  (positie.x + Math.sin(bewegingsrichting) * v * t);}
   public double yt(long t) {return  (positie.y + Math.cos(bewegingsrichting) * v * t);}

/**
* Methoden schatten de x,y-waarden van het doel op tijd t o.b.v. de aanname
* dat het doel een lineaire beweging uitvoert met zijn gemiddelde snelheid.
*/
   public double xtMean(long t) {return  (positie.x + Math.sin(bewegingsrichting) * vGem * t);}
   public double ytMean(long t) {return  (positie.y + Math.cos(bewegingsrichting) * vGem * t);}

/**
* Methoden geven de op de huidige en gemiddelde afgelegde weg.
*/
   public double afgelegdeweg() {return (HulpRoutines.bepaalAfstand(positie, positie_o));}
   public double totAfgelegdeweg() {return  (gemAfgelegdeWeg += afgelegdeweg());}

/**********************************************************************
** methoden voor patroon herkenning:
**********************************************************************/
   public double getVoorspeldeDoelhoek(double vKogel, Fenrir bot) {
      int      matchIndex, zoeklengte;
      double   hoek;

      ++probeerTeller; // nieuwe poging patroonherkenning

      if (bot.meleeModus) zoekdiepte = (int)(ZOEK_DIEPTE/2D);
      else                zoekdiepte = ZOEK_DIEPTE;

      // Gebruik standaard Java functionaliteit om de positie van een substring
      // op te zoeken en een andere string: hier de StringBuffer bewegingsPatroon.
      // De method lastIndexOf wordt gebruikt om zo snel mogelijk nieuw gedrag
      // te kunnen herkennen en hierop te reageren.
      zoeklengte = zoekdiepte;
      do {
         matchIndex = bewegingsPatroon.toString().lastIndexOf(
                      bewegingsPatroon.substring( Math.max((scanTeller - zoeklengte), 0) )
                                                ,(int)Math.max((scanTeller- (1000/vKogel) - zoeklengte), 0)
                                                );
      } while ( (zoeklengte -= 1)*matchIndex < -1 );

      if (matchIndex == -1 ) {
         matchIndex    = scanTeller-1;
         patroonLocked = false;
      }
      else {
         matchIndex   += (zoeklengte+1);
         matchIndex    = matchIndex%PATROONLENGTE;
         patroonLocked = true;
         gemiddeldePatroonLengte += zoeklengte;
         ++succesTeller; // geslaagde poging patroonherkenning
      }

      if ( v == 0 && (!patroonLocked || e == 0 ) ) {
         hoek = richting;
      }
      else {
         if (!patroonLocked) {
            hoek = lineaireBewegingsSchatter(new Point2D.Double(bot.getX(), bot.getY())
                                            ,bot.getTime()
                                            ,vKogel
                                            );
         }
         else {
            hoek = bepaalHoek(matchIndex, vKogel);
         }
      }

      return( HulpRoutines.normaliseerRichting( hoek ) );
  }

   public boolean getVuurAdvies() {
      return(patroonLocked);
   }

   public double bepaalHoek(int matchIndex, double kogelSnelheid) {
      double x;
      double y;
      double ah;

      x  = Math.sin(richting) * afstand;
      y  = Math.cos(richting) * afstand;
      ah = bewegingsrichting_o + (snelheid[scanTeller%PATROONLENGTE] * snelheid[matchIndex] >= 0.0D ? 0.0D : PI);

      for(int time = 2; (double)time * kogelSnelheid < Point2D.distance(0.0D, 0.0D, x, y); time++)
      {
          x += Math.sin(ah) * snelheid[(matchIndex + time)%PATROONLENGTE];
          y += Math.cos(ah) * snelheid[(matchIndex + time)%PATROONLENGTE];
          ah += rotatie[(matchIndex + time)%PATROONLENGTE];
      }

      return Math.atan2(x, y);
   }

/**********************************************************************
*  DOEL RICHTING SCHATTERS
**********************************************************************/
/**
* LineaireDoelRichtingVoorspelling: berekend de verwachte Doel bearing op tijd T+deltaT
*    o.b.v. snelheid kogel, (x,y)Robot, (x,y)Doel, Doel bearing, Doel heading
*    en de Robot heading
*    Directe berekening (zie aantekeningen).
*
* v0.1 (27-08-2002)
*/

   public double lineaireBewegingsSchatter(Point2D.Double botPositie, long tijd, double vKogel) {
      int    t;
      double xSchat = 0;
      double ySchat = 0;
      double dSchat = afstand;
      for (int i = 0; i < 4; i++)
      { // iteratie om afstand tot doel te schatten (geen wijziging
        // in resultaat na 4 iteraties (getest tegen spinbot)))
         t = (int)(Math.round(dSchat/vKogel) + (tijd - scanTijd) + 1);
         xSchat = xtMean(t);
         ySchat = ytMean(t);
         dSchat = HulpRoutines.bepaalAfstand(new Point2D.Double(xSchat,ySchat), botPositie);
      }
// controleer of doel-positie niet buiten slagveld wordt geschat:
      Point2D.Double p = new Point2D.Double(xSchat,ySchat);

      return ( HulpRoutines.bepaalRichting( p, botPositie ) );
   }

   public double getCorrectieDoelhoek()
   {
      return(correctieDoelhoek);
   }
   public void setCorrectieDoelhoek(double dh)
   {
      correctieDoelhoek= 0.9 * correctieDoelhoek + 0.1 * dh;
   }

/**********************************************************************
** methoden om statistiek bij te werken: dit zijn mijn (bvh) resultaten
**********************************************************************/
   public int getTreffersBvh() {
      if (treffersBvh[0][0]==0)
         return 99999999;
      else
         return(treffersBvh[0][0]);
   }
   public void setTreffersBvh(BulletHitEvent e) {
      ++treffersBvh[0][0];

      /*
       * This sets the distance indices as follows (code from microDualist ? by David Alves):
       *
       * 0: Unused (Not subtracting 1 reduces codesize :-) )
       * 1:   0 -  90 (Essentially point blank range)
       * 2:  91 - 250
       * 3: 251 - 490
       * 4: 491 - 810
       * 5: 811+
       */
      int afstandIndex = Math.min( (int)Math.round(Math.sqrt(afstand / 40.0)), 6 );
      int powerIndex   = Math.min( (int)Math.round( e.getBullet().getPower()+0.45 ), 4 );

      ++treffersBvh[afstandIndex][powerIndex];

   }
   public int getSchotenBvh() {
      if (schotenBvh[0][0]==0)
         return 99999999;
      else
      return(schotenBvh[0][0]);
   }
   public void setSchotenBvh() {
      ++schotenBvh[0][0];
   }
/**********************************************************************
** methoden om statistiek bij te werken: resultaten opponent
**********************************************************************/
   public int getTreffers() {
      return(treffers[0][0]);
   }
   public void setTreffers(HitByBulletEvent e) {
      ++treffers[0][0];

      /*
       * This sets the distance indices as follows:
       *
       * 0: Unused (Not subtracting 1 reduces codesize :-) )
       * 1:   0 -  90 (Essentially point blank range)
       * 2:  91 - 250
       * 3: 251 - 490
       * 4: 491 - 810
       * 5: 811+
       */
      int afstandIndex = Math.min((int)Math.round(Math.sqrt(afstand / 40.0)), 6);
      int powerIndex   = Math.min((int)Math.round( e.getPower()+0.45) , 4);

      ++treffers[afstandIndex][powerIndex];
   }
   public int getSchoten() {
      return(schoten[0][0]);
   }
   public void setSchoten() {
      ++schoten[0][0];
   }

}
/**********************************************************************
** EINDE CLASS DOEL
**********************************************************************/