/*
 * Observation.java
 *
 * Created on 14 maart 2004, 23:20
 */
package vic;
/**
 *
 * @author  Vic Stewart
 */
public class Observation extends Situation
{
    double delta_distance;
    double delta_heading;
    int Age;
    
    Observation()
    {
    }
    
    Observation(Situation pSituation, double delta_distance, double delta_heading)
    {
        super(pSituation);
        setTravelPoint(delta_distance, delta_heading);
    }
    
    int getAge()
    {
        return Age;
    }
    
    void setAge(int pAge)
    {
        Age = pAge;
    }
    
    void setTravelPoint(double pDelta_distance, double pDelta_heading)
    {
        delta_distance = pDelta_distance;
        delta_heading  = pDelta_heading;
    }

    double getProjectedFiringAngle(byte ETA, double enemyX, double enemyY, double currentHeading, double meX, double meY)
    {
        double projectedX = projectX(enemyX, currentHeading, TimeFactor(ETA));
        double projectedY = projectY(enemyY, currentHeading, TimeFactor(ETA));
        if(projectedX == -1 | projectedY == -1 )return 666;	//outside battlefield
	  else return getAbsoluteAngle(meX, meY, projectedX, projectedY);
    }
    double projectX(double enemyX, double currentHeading, double distanceFactor)
    {
        double result = enemyX + (Math.sin(currentHeading + delta_heading) * delta_distance * distanceFactor);
        return checkInBattlefield(result, getBattlefieldWidth());
    }
    
    double projectY(double enemyY, double currentHeading, double distanceFactor)
    {
        double result = enemyY + (Math.cos(currentHeading + delta_heading) * delta_distance * distanceFactor);
        return checkInBattlefield(result, getBattlefieldHeight());
    }
    
    double checkInBattlefield(double result, double max)
    {
        if (result < getHalfRobotWidth()      ) result = -1;
        if (result > max - getHalfRobotWidth()) result = -1;
        return result;
    }
}

