/* 
		Basilite - a baby Basilisk!
Features stop and go, random movement, and pattern matching
				
			By Slugzilla
			
CREDITS: Basilite is based off of a few robots, including Basilisk and BlackWidow

 */

package slugzilla;
import robocode.*;
import java.awt.geom.*;
import robocode.util.Utils;
import robocode.util.*;
import java.awt.*;
//import static robocode.util.Utils.normalRelativeAngleDegrees;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
 
public class Basilite extends AdvancedRobot {
	//movement
	static double enemyBulletVelocity;
	static double hits;
	static double enemyEnergy;
	static int deltaT;
	static int lastDeltaT;
	static int lastReverseTime;
	static double direction = 1;
	static int movementMode;
	//gun					  
//	static String enemyLog = "000000000000000000000000000000888888888888888765432100888765432101234567888765432100";

	public static final int MAX_SEARCH_PATTERN_LENGTH = 50;
    
    private static String history = "" + 
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8 +
	    (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 +
	    (char)8 + (char)7 + (char)6 + (char)5 + (char)4 + (char)3 + (char)2 + (char)1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 + (char)-7 + (char)-8 +
	    (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 +
	    (char)-8 + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0; 

    public void run() {
        setAdjustRadarForGunTurn(true);
 		setAdjustGunForRobotTurn(true);
		setBodyColor(new Color(40, 100, 100));
		setGunColor(new Color(34, 50, 50));
		setRadarColor(new Color(0, 255, 0));
		setScanColor(new Color(0, 255, 0));
	 	turnRadarRightRadians(Double.POSITIVE_INFINITY);
        do {
            scan();
        } while (true);
    }
	
    public void onScannedRobot(ScannedRobotEvent e) {
		//movement ↓
 		double enemyDistance =  e.getDistance();
    	double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double v2; 
		double offset;
		double theta;
		int antiRam;
		offset = 2 - movementMode + (antiRam = ((int)(100/enemyDistance)));
	//	offset = 2 - movementMode/2 + (antiRam = ((int)(100/enemyDistance)));
		
		while(!new Rectangle2D.Double(18, 18, 764, 564).
			contains(getX() + 160 * Math.sin(v2 = absoluteBearing + direction * (offset -= .02)), getY() + 160 * Math.cos(v2)));

		setTurnRightRadians(Math.tan(v2 -= getHeadingRadians()));
		
		deltaT = (int)getTime() - lastReverseTime;
		if (movementMode * -Math.random() > Math.pow((theta = 0.5952 * enemyBulletVelocity / enemyDistance), theta) + antiRam || offset < Math.PI/4) {		
			if (deltaT >= lastDeltaT + (6/Math.abs(getVelocity())) || deltaT <= lastDeltaT - (6/Math.abs(getVelocity()))) {
				direction = -direction;
				lastDeltaT = deltaT;
				lastReverseTime = (int)getTime();
			}
		}
		
		double energyDrop = enemyEnergy - (enemyEnergy = e.getEnergy());
		if (antiRam + energyDrop > movementMode) {
			setAhead(((3 + (int)(energyDrop * 1.999999)) << 3 ) * (Math.cos(v2)));
		}	
		
			//radar ↓
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		//gun
		double power = Math.min(15.0 * getEnergy() / e.getDistance(), e.getEnergy() / 4.0);
	
	//	double power = Math.min(3, Math.min(1.95, Math.min(getEnergy()/8, e.getEnergy()/4)) + 3 * antiRam);
		double velocity = Rules.getBulletSpeed(power);
		int i = MAX_SEARCH_PATTERN_LENGTH;
		int matchIndex;
		
		history = String.valueOf((char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing))).concat(history);
		
		//while((matchIndex = history.indexOf(history.substring(0, i--), (int)(e.getDistance() / velocity + 1.0))) < 0);
		//i = (int)(e.getDistance() / velocity + 1.0);
		while((matchIndex = history.indexOf(history.substring(0, i--), (int)(e.getDistance() / velocity))) < 0);
		i = (int)(e.getDistance() / velocity);
		do { absoluteBearing += Math.asin(((short)history.charAt(--matchIndex)) / e.getDistance()); } while (--i > 0);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		setFire(power);
    
	}
	//movement ↓
	public void onHitByBullet(HitByBulletEvent e) {	
		enemyEnergy += Rules.getBulletHitBonus(e.getPower());
		if ((hits += Math.abs(deltaT) > 30 ? 5 / (enemyBulletVelocity = e.getVelocity()) : 0) > getRoundNum() + 2) {
			movementMode = -1;
		}
    }
	public void onBulletHit(BulletHitEvent e) {
		enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
}