package hirataatsushi;

import robocode.*;
import java.awt.geom.*;

/**
 * SimpleAimingStrategy a class by A.Hirata.
 */
public class SimpleAimingStrategy implements AimingStrategy
{
	private AdvancedRobot myBot = null;
	
	private TargetManager targetManager = TargetManager.getInstance();
	
	private int firePower = 1;
	
	public SimpleAimingStrategy(AdvancedRobot bot){
		myBot = bot;
	}
	
	public void doAction(){
		Enemy t = null;
		t = targetManager.getNearestTarget();
		System.out.print("CurrentTarget is ");System.out.println(t.getName());
		//myBot.setTurnGunRightRadians(t.getBearing());
		setGunToTargetAndFire(t);
		myBot.fire(1);	
	}	
	
	
	private void setGunToTargetAndFire(Enemy target){
		long time = myBot.getTime() 
			+ (int)Math.round(
				( Helper.getRange(myBot.getX(), myBot.getY(), target.getX(),target.getY())
					/
				(20 - ( 3 * firePower ) )
				)
			);
		Point2D.Double p = target.guessPosition(time);
		double gunOffset = Math.atan2( p.x - myBot.getX(), p.y - myBot.getY() )
			- myBot.getGunHeadingRadians();
		myBot.setTurnGunRightRadians(Helper.normalizeBearingRadians(gunOffset));
		
		if (target.getDistance() < 3 * myBot.getWidth() ) {
			firePower = 3;
			System.out.println("FULL POWER FIRE!!");
		} else {
			firePower = 1;
		} 
		myBot.fire( firePower );
	}
	
}
