package hirataatsushi;
import robocode.*;


/**
 * Trinity - a robot by (your name here)
 */
public class Trinity extends AdvancedRobot
{

	private TheSoul mySoul = null;
	private TheRationality myRationality = TheRationality.getInstance();

	/**
	 * run: Trinity's default behavior
	 */
	public void run() {
		myRationality.setMyBot(this);

		while(true) {
			mySoul = myRationality.makeJudgement();
			mySoul.doAction();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		myRationality.onScannedRobot(e);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onHitWall(HitWallEvent e) {
		myRationality.onHitWall(e);
	}
	
	
	
	
	
	/**===========================================
	 * Custom Events
	 =============================================*/
	
	/**
	 * onCustomEvent(CustomEvent e)
	 */
	public void onCustomEvent(CustomEvent e){
		myRationality.onCustomEvent(e);
	}
	
}
