package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* MoveLR3.java -- for melee
*                 G߂Ƃ̍Eړ4
*                 ǍۂɐwCR[i[
*
* Date:		2002/Nov/22
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class MoveLR4 implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	FieldMap map;
	int dir = 1, dir2 = 1;
	boolean isNearCorner = false;
	int nearWall, nearCorner;
	
	final int NORTH = MyRobot.NORTH;
	final int SOUTH = MyRobot.SOUTH;
	final int WEST = MyRobot.WEST;
	final int EAST = MyRobot.EAST;
	final int NE = MyRobot.NE;
	final int SE = MyRobot.SE;
	final int NW = MyRobot.NW;
	final int SW = MyRobot.SW;	

	
	//---------------------------------------------------------
	// constructor
	//
	//
	//---------------------------------------------------------
	public MoveLR4(MyRobot my) {
		this.my = my;

		fW = my.fW;
		fH = my.fH;
		map = my.map;
		init();
	}
	
	public void init() {
		dstX = my.getX();
		dstY = my.getY();
		my.EPSILON = 50;
		my.setMaxVelocity(8);
	}
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		Enemy ene = map.getNearestEnemy(my.getTime());

		if (ene == null) return;
//M.print("enemy name = " + ene.getName());
		
		double angle;		//[_[]px
		double absoluteBearing;		//Gʒu̐Ίpx
		double bearing, distance;
		
		bearing = ene.getBearing();
		distance = ene.getDistance();

		absoluteBearing = M.angleUnder180(bearing + my.getHeading());
		
//M.print("absoluteBearing = " + absoluteBearing);
		

	double dx = 0, dy = 0;			//Ǎۂ֍s߂̃Q^
	
	if (my.isArrived(dstX, dstY)) {
		setNearWall();
		setNearCorner();
		
		double ab = absoluteBearing;
		switch (nearWall) {
				case NORTH:
					dy = 20;
					if      (0 < ab && ab <= 45)  dir2 = -1;
					else if (-45 < ab && ab <= 0) dir2 = 1;
					else if (rand.nextInt(5) == 0) dir2 *= -1;
					break;
				case EAST:
					dx = 20;
					if      (90 < ab && ab <= 180) dir2 = -1;
					else if (0 < ab && ab <= 90)   dir2 = 1;
					else if (rand.nextInt(5) == 0) dir2 *= -1;
					break;
				case SOUTH:
					dy = -20;
					if      (-180 < ab && ab <= -90) dir2 = -1;
					else if (90 < ab && ab <= 180)   dir2 = 1;
					else if (rand.nextInt(5) == 0) dir2 *= -1;
					break;
				case WEST:
					dx = -20;
					if      (-180 < ab && ab <= -90) dir2 = 1;
					else if (-90 < ab && ab <= 0)    dir2 = -1;
					else if (rand.nextInt(5) == 0) dir2 *= -1;
					break;
				default:
					if (rand.nextInt(5) == 0) dir2 *= -1;
		}
		
		
		
		//ǋ߂
		double MWall = 150;
		if (my.getX() < MWall || my.getX() > fW - MWall || my.getY() < MWall || my.getY() > fH - MWall) {
			if (rand.nextInt(5) == 0) dir *= -1;
			dx = dy = 0;			
		} else {
			dir = dir2;	
		}
//M.print("dir = " + dir);


		switch(nearCorner) {
			case NE:
				dx += 10;
				dy += 10;
				break;
			case SE:
				dx += 10;
				dy += -10;
				break;
			case SW:
				dx += -10;
				dy += -10;
				break;
			case NW:
				dx += -10;
				dy += 10;
				break;				
		}
		
		double goAngle;
		
		if (distance < 250) {
			goAngle = absoluteBearing + dir * 110;
		} else {
			goAngle = absoluteBearing + dir * 90;
			double rr = rand.nextInt(140) - 70;
			int sign = M.sign(rr);
			goAngle += rr * rr / 90 * sign;
//			goAngle = absoluteBearing + dir * (55 + (100 / distance) * 30);		
//			goAngle = absoluteBearing + dir * (90 * Math.sqrt(distance / 800));
		}
	
		Point po = M.degree2point(goAngle, 70);
				
		dstX = my.getX() + po.x + dx;
		dstY = my.getY() + po.y + dy;
		
//		if (rand.nextInt(15) == 0) dir *= -1;

		correctDestination();
//M.print("set next point = " + dstX + " " + dstY);

	}
	
	
		//speed
//		my.setMaxVelocity(rand.nextInt(5) + 5);
		
		my.setGoPos(dstX, dstY);
//M.print("moveLR4");
	}

	//------------------------------------------------------------------
	// setNearWall()
	//
	//
	//------------------------------------------------------------------
	void setNearWall() {
		double min = my.getX();
		double myX = my.getX();
		double myY = my.getY();
		
		nearWall = WEST;
		dstX = myX;
		dstY = myY;
		
		//Ƃ߂ǂ̕ṕH
		if (min > fH - myY) {
			nearWall = NORTH;
			min = fH - myY;
		}

		if (min > fW - myX) {
			nearWall = EAST;
			min = fW - myX;
		}
		
		if (min > myY) {
			nearWall = SOUTH;
			min = myY;
		}
//M.print("setNearWall = " + nearWall);

	}

	//------------------------------------------------------------------
	// setNearCorner()
	//
	//
	//------------------------------------------------------------------
	void setNearCorner() {
		double myX = my.getX();
		double myY = my.getY();
		
		if (nearWall == NORTH) {
			if (myX < fW - myX) nearCorner = NW;
			else                      nearCorner = NE;
		} else if (nearWall == EAST) {
			if (myY < fH - myY) nearCorner = SE;
			else                      nearCorner = NE;				
		} else if (nearWall == SOUTH) {
			if (myX < fW - myX) nearCorner = SW;
			else                      nearCorner = SE;
		} else if (nearWall == WEST) {
			if (myY < fH - myY) nearCorner = SW;
			else                      nearCorner = NW;				
		}
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		//my.setGoPos(dstX, dstY);
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {		
		my.result.damage();
	}
	
	//--------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 50;
		int wall = 0;
		
		if (dstX < MARGIN) {
			dstX = MARGIN + 200;
			dir *= -1;
			wall++;
		} else if (fW - dstX < MARGIN)  {
			dstX = fW - MARGIN - 200;
			dir *= -1;
			wall++;
		}

		if (dstY < MARGIN) {
			dstY = MARGIN;
			dir *= -1;
			wall++;
		} else  if (fH - dstY < MARGIN) {
			dstY = fH - MARGIN;
			dir *= -1;
			wall++;
		}
		
		if (wall == 2) isNearCorner = true;
	}
	
	//----------------------------------
	// scannedRobot()
	//----------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
	}
}