package dft.bin;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class Wave {
	
	public ArrayList buffers;
	
	public Point2D waveOrigin;
	public Point2D waveLocation;
	public Point2D targetLocation;
	
	public double angle;
	public double velocity;
	public double escapeEnvelope;
	public double delay;
	
	public long fireTime;
	public long lastTime;
	
	public boolean real;
	
	public abstract void increment(double GF);
	public abstract boolean isGunWave();
	
	public boolean update(Point2D newLocation, long time) {		
		while (lastTime < time) {
			double dTime = time-lastTime;
			waveLocation = Utils.project(waveLocation,angle,velocity);
			double dX = (newLocation.getX()-targetLocation.getX())/dTime;
			double dY = (newLocation.getY()-targetLocation.getY())/dTime;
			
			targetLocation.setLocation(targetLocation.getX()+dX, targetLocation.getY()+dY);
			if (waveOrigin.distance(waveLocation)-delay>waveOrigin.distance(targetLocation)-velocity*1.5)
				return true;
			lastTime++;
		}
		return false;
	}
	
}
