// $Id: WaveGun.java,v 1.5.6.1.2.3 2004/10/28 10:01:30 lolo Exp $
package mnt.utils;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;

public class WaveGun {
	private double bearingDir = 1;

	private double ultimaVelRelativa, ultimaVelocidad, velocidadRelativa,
			velocidad;

	private double energiaEnemigo, distanciaEnemigo;

	private Point2D.Double posEnemigo;

	private Point2D.Double miPos;

	public static final boolean GL = true;

	public static final int MITAD_FACTORES = 12;

	public static final int FACTORES = 2 * MITAD_FACTORES;

	public static final int POTENCIA_BALA = 2;

	private static double[][][][][][] guessFactors = new double[4][3][5][3][6][FACTORES + 1];

	private List waves = new ArrayList();

	private AdvancedRobot miRobot;

	public WaveGun(AdvancedRobot a) {
		miRobot = a;
		waves.clear();
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		miPos = new Point2D.Double(miRobot.getX(), miRobot.getY());
		double enemiBearing = miRobot.getHeadingRadians()
				+ e.getBearingRadians();
		distanciaEnemigo = e.getDistance();
		posEnemigo = RoboMath.calculaPosicion(miPos, enemiBearing,
				distanciaEnemigo);
		energiaEnemigo = e.getEnergy();

		actualizarWaves();
		boolean esBala = false;
		if (miRobot.getGunHeat() == 0)
			esBala = true;

		Wave w = new Wave(esBala);
		waves.add(w);

		ultimaVelRelativa = velocidadRelativa;
		ultimaVelocidad = velocidad;
		velocidadRelativa = (velocidad = e.getVelocity())
				* Math.sin(e.getHeadingRadians() - enemiBearing);

		int indiceDeDistancia = Math.min(5, (int) distanciaEnemigo / 140);

		double potenciaBala = indiceDeDistancia == 0 ? 3 : POTENCIA_BALA;
		potenciaBala = Math.min(miRobot.getEnergy() / 3, Math.min(
				energiaEnemigo / 4, potenciaBala));

		int indicePotenciaBala = (int) potenciaBala;

		w.velocidadBala = RoboMath.velocidadBala(potenciaBala);

		int indiceDeAceleracion = (int) Math.round(Math.abs(velocidadRelativa)
				- Math.abs(ultimaVelRelativa));

		if (velocidadRelativa != 0)
			bearingDir = velocidadRelativa > 0 ? 1 : -1;
		w.dirBearing = bearingDir * RoboMath.maxAnguloDeHuida(w.velocidadBala)
				/ MITAD_FACTORES;

		int bestGF = 0;

		int indiceDeVelocidad = (int) Math.abs(velocidadRelativa / 3);

		if (Math.abs(Math.abs(velocidad) - Math.abs(ultimaVelocidad)) > .6) {
			indiceDeAceleracion = (int) Math.round(Math.abs(velocidad)
					- Math.abs(ultimaVelocidad));
			indiceDeVelocidad = (int) Math.abs(velocidad / 3);
		}

		if (indiceDeAceleracion != 0)
			indiceDeAceleracion = indiceDeAceleracion > 0 ? 1 : 2;

		w.centro = miPos;
		w.enemiBearing = enemiBearing;

		w.waveGuessFactors = guessFactors[indicePotenciaBala][indiceDeAceleracion][bestGF][indiceDeVelocidad][indiceDeDistancia];

		bestGF = MITAD_FACTORES;

		if (energiaEnemigo > 0)
			bestGF = mejorGF(w.waveGuessFactors);

		miRobot.setTurnGunRightRadians(Utils.normalRelativeAngle(enemiBearing
				- miRobot.getGunHeadingRadians() + w.dirBearing
				* (bestGF - MITAD_FACTORES)));

		if (miRobot.getEnergy() > 1 || indiceDeDistancia == 0)
			if (miRobot.getGunHeat() == 0) {
				w.peso = 3;
				miRobot.setFire(potenciaBala);
			}
	}

	private int mejorGF(double[] gfs) {
		int bestGF = MITAD_FACTORES;
		for (int i = 0; i < gfs.length; i++) {
			if (gfs[i] > gfs[bestGF])
				bestGF = i;
		}
		return bestGF;
	}

	private void actualizarWaves() {
		for (Iterator it = waves.iterator(); it.hasNext();) {
			Wave w = (Wave) it.next();
			//            if (w.esBala)
			//                w.dibujar();
			if (w.pasada(posEnemigo))
				it.remove();
		}
	}
}