package com.timothyveletta.states;

import com.timothyveletta.*;

public class ApproachEnemyState extends State {
	private double maxDist;

	public ApproachEnemyState(FuzzyBot obj) {
		super(obj);
	}
	
	@Override
	public void Init() {
		maxDist = MathHelper.Pythagoras(object.getBattleFieldWidth(), object.getBattleFieldHeight());
	}

	@Override
	public void Update() {
		super.Update();
		
		ForceVector vec = new ForceVector(object.enemyX - object.myX, object.enemyY - object.myY);

		vec.NormaliseVector();
		
		vec.x = vec.x * activationLevel;
		vec.y = vec.y * activationLevel;
		
		
		
		object.applyForce(vec);
	}

	@Override
	public void CalculateActivation() {
		activationLevel = AIControl.nearestEnemyDist / maxDist;		
	}
}
