package gadsky;

import robocode.Rules;

public final class Shot {
	public final long time;
	public final Vector2D source;
	private final Vector2D position;
	public final double bulletSpeed;

	public boolean resolved = false;
	public double heading;
	private double angle;

	public Shot(long time, Vector2D source, double bulletPower, Vector2D position) {
		this.time = time;
		this.source = source;
		this.position = position;
		bulletSpeed = Rules.getBulletSpeed(bulletPower);
	}

	public final void resolve(long time, Vector2D hit, double heading, double bulletSpeed) {
		if (resolved) return;

		double deltaSpeed = bulletSpeed - this.bulletSpeed;
		if (Math.abs(deltaSpeed) > 0.1) return;

		long deltaTime = time - this.time;
		double distance = bulletSpeed * deltaTime;
		Vector2D canHit = source.add(Vector2D.EX.rotated(heading).mul(distance));
		Vector2D deltaHit = hit.sub(canHit);

		if (deltaHit.length() <= 20) {
			resolved = true;
			this.heading = heading;
			angle = position.sub(source).signedAngle(hit.sub(source));
		}
	}
}
