package whind;
import java.awt.geom.*;
/**
 * EnemyWave - a class by Greywhind
 */
public class EnemyWave {
		public double startx, starty, startBearing, power, opposBearing, distance;
        public long fireTime;
        public int direction;
        public double[] returnSegment;
		public int[] segmentLocation;
		int index;
		public boolean hasBullet;
        
        public EnemyWave(double x, double y, double dist, double bearing, double obearing, double power, int direction, long time, double[] segment, int[] segmentLoc, boolean bulletCarrying)
        {
                startx = x;
                starty = y;
				distance = dist;
                startBearing = bearing;
				opposBearing = obearing;
                this.power = power;
                this.direction = direction;
                fireTime = time;
                returnSegment = segment;
				segmentLocation = segmentLoc;
				hasBullet = bulletCarrying;
        }

		public EnemyWave(EnemyWave other) {
			startx = other.startx;
            starty = other.starty;
			distance = other.distance;
            startBearing = other.startBearing;
			opposBearing = other.opposBearing;
            this.power = other.power;
            this.direction = other.direction;
            fireTime = other.fireTime;
            returnSegment = other.returnSegment;
			hasBullet = other.hasBullet;
		}

        public double getBulletSpeed()
        {
                return 20-power*3;
        }
        
        public double maxEscapeAngle()
        {
                return Math.asin(8/getBulletSpeed());
        }
 		
		public int checkHit(double enemyX, double enemyY, long currentTime)
        {
                //if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
                if (Point2D.distance(startx, starty, enemyX, enemyY) <= (currentTime-(fireTime - 2))*getBulletSpeed())
                {
					double desiredDirection = Math.atan2(enemyX-startx, enemyY-starty);
                    double angleOffset = robocode.util.Utils.normalRelativeAngle(desiredDirection-startBearing);
                    double guessFactor = Math.max(-1, Math.min(1, angleOffset/maxEscapeAngle()))*direction;
                    int index = (int)Math.round((returnSegment.length-1)/2*(guessFactor+1));
					
					if (hasBullet == true) {
                        //returnSegment[index]++;
					}
					
					return index;
                }
                return -1;
        }
}
