package whind;

import java.awt.geom.*;
import robocode.util.Utils;
import robocode.*;
import whind.VBullet;
import java.util.Vector;

/**
 * VGunBattery - a class by Greywhind
 */
public class VGunBattery
{
	static int NUMOFVGUNS = 6;
	static int HEADONGUN = 0;
	static int LINEARGUN = 1;
	static int CIRCULARGUN = 2;
	static int LASERGUN = 3;
	static int PMGUN = 4;
	static int GFGUN = 5;
	static int[] gunValues = new int[NUMOFVGUNS];
	Vector bulletsInAir;
	double angleOffset;
	double headOnAim;
	double desiredDirection;
	VBullet tB;
	double bFieldHeight;
	double bFieldWidth;
	
	double cPredictedAngle;
	double hPredictedAngle;
	double lPredictedAngle;
	double laPredictedAngle;
	double pmPredictedAngle;
	double gfPredictedAngle;
		
	public VGunBattery(double bFH, double bFW) {
		bulletsInAir = new Vector();
		bFieldHeight = bFH;
		bFieldWidth = bFW;
	}
	
	public void addBullet(double x, double y, double bearing, double power, int direction, long time, double headRad, double prevheadrad, double eVel, double hon, double lin, double circ, double las, double pm, double gf) {
		VBullet addThis = new VBullet(x, y, bearing, power, direction, time, headRad, prevheadrad, eVel, hon, lin, circ, las, pm, gf);
		bulletsInAir.add(addThis);
	}
	
	public VBullet checkBullets(ScannedRobotEvent e, double enemyX, double enemyY, long currentTime, double distance) {
		for (int i = 1; i < bulletsInAir.size(); i++) {
			VBullet aB = (VBullet)bulletsInAir.get(i);
			tB = new VBullet(aB.startx, aB.starty, aB.startBearing, aB.power, aB.direction, aB.fireTime, aB.headingRadians, aB.prevHeadingRadians, aB.eVelocity, aB.headOnPredicted, aB.linearPredicted, aB.circularPredicted, aB.laserPredicted, aB.patternPredicted, aB.guessFactorPredicted);
			if (Point2D.distance(tB.startx, tB.starty, enemyX, enemyY) <= (currentTime-tB.fireTime)*tB.getBulletSpeed()) {
             	desiredDirection = Math.atan2(enemyX-aB.startx, enemyY-aB.starty);
             	angleOffset = Math.toDegrees(robocode.util.Utils.normalRelativeAngle(desiredDirection));
				
				// add gun checks here.
				checkHitHeadOn(tB, distance);
				checkHitLinear(tB, distance);
				checkHitCircular(tB, distance);
				checkHitLaser(tB, distance);
				checkHitPattern(tB, distance);
				checkHitGuessFactor(tB, distance);
				bulletsInAir.remove(i);
				return tB;
			}
		}
		return null;
	}
	
	public int returnBestGun() {
		int bestGunVal = 0;
		int bestGun = 0;
		for (int x = 0; x < NUMOFVGUNS; x++) {
			if (gunValues[x] >= bestGunVal) {
				bestGun = x;
				bestGunVal = gunValues[x];
			}
		}
		return bestGun;
	}
	
	public void checkHitHeadOn(VBullet theB, double dist) {
		headOnAim = theB.headOnPredicted;
		hPredictedAngle = headOnAim;
			
		if (angleOffset != 0 && headOnAim != 0) {
			if (Math.abs(angleOffset) < Math.abs(headOnAim) + (26 / (dist/100)) && Math.abs(angleOffset) > Math.abs(headOnAim) - (26 / (dist/100))) {
				gunValues[HEADONGUN]++;
			}
		}
	}
	
	public void checkHitLinear(VBullet theB, double dist) {
        double predictedAngle = theB.linearPredicted;
		lPredictedAngle = predictedAngle;
				
		if (angleOffset != 0 && predictedAngle != 0) {
			if (Math.abs(angleOffset) < Math.abs(predictedAngle) + (26 / (dist/100)) &&Math.abs(angleOffset) > Math.abs(predictedAngle) - (26 / (dist/100))) {
				gunValues[LINEARGUN]++;
			}
		}
	}
	
	public void checkHitCircular(VBullet theB, double dist) {
        double predictedAngle = theB.circularPredicted;
		cPredictedAngle = predictedAngle;
				
		if (angleOffset != 0 && predictedAngle != 0) {
			if (Math.abs(angleOffset) < Math.abs(predictedAngle) + (26 / (dist/100)) && Math.abs(angleOffset) > Math.abs(predictedAngle) - (26 / (dist/100))) {
				gunValues[CIRCULARGUN]++;
			}
		}
	}
	
	public void checkHitLaser(VBullet theB, double dist) {
        double predictedAngle = theB.laserPredicted;
		laPredictedAngle = predictedAngle;
				
		if (angleOffset != 0 && predictedAngle != 0) {
			if (Math.abs(angleOffset) < Math.abs(predictedAngle) + (26 / (dist/100)) && Math.abs(angleOffset) > Math.abs(predictedAngle) - (26 / (dist/100))) {
				gunValues[LASERGUN]++;
			}
		}
	}
	
	public void checkHitPattern(VBullet theB, double dist) {
		double predictedAngle = theB.patternPredicted;
		pmPredictedAngle = predictedAngle;
				
		if (angleOffset != 0 && predictedAngle != 0) {
			if (Math.abs(angleOffset) < Math.abs(predictedAngle) + (26 / (dist/100)) && Math.abs(angleOffset) > Math.abs(predictedAngle) - (26 / (dist/100))) {
				gunValues[PMGUN]++;
			}
		}
	}
	
	
	public void checkHitGuessFactor(VBullet theB, double dist) {
		double predictedAngle = theB.guessFactorPredicted;
		gfPredictedAngle = predictedAngle;
				
		if (angleOffset != 0 && predictedAngle != 0) {
			if (Math.abs(angleOffset) < Math.abs(predictedAngle) + (26 / (dist/100)) && Math.abs(angleOffset) > Math.abs(predictedAngle) - (26 / (dist/100))) {
				gunValues[GFGUN]++;
			}
		}
	}
}
