package djc;

import djc.util.*;
import java.awt.*;
import java.awt.geom.*;     // for Point2D's
import java.util.*; 	    // for collection of waves
import robocode.*;

/**
 * For managing data on the battlefield
 */
public class BattlefieldManager
{
	/********************************************************************************
	 *                        Member Variables                                      *
	 *******************************************************************************/
	public static AbstractDynaBot myrobot = null;

	public ArrayList activeBulletsFired  = new ArrayList();
	public ArrayList virtualBulletsFired = new ArrayList();
		
	public ArrayList enemyBulletsFired  = new ArrayList();
	public static double battleFieldWidth  = 0;
	public static double battleFieldHeight = 0;
	public static Rectangle2D.Double fieldRect = new Rectangle2D.Double(0,0,600,800);        // The actual battlefield dimesions
	public static Rectangle2D.Double inFieldRect = new Rectangle2D.Double(0,0,600,800);      // Where bots can actually be on the field
	public static Rectangle2D.Double vbFieldRect = new Rectangle2D.Double(0,0,600,800);      // The actual battlefield dimesions for 
																							 // virtual bullets (which is bigger than the actual field)
	public static final double BOT_WIDTH = 18.0;
	
	// Landmark positions and areas
	//public static Rectangle2D.Double []cornerAreas;
	public static Polygon []cornerAreas;
	public static Point2D.Double []cornerAreaCenters;
	public static Point2D.Double arenaCenter = new Point2D.Double(300, 400);
	
	private static Color []vGunColor = {Color.red, Color.green, Color.yellow, Color.blue, Color.orange, Color.cyan, Color.magenta, Color.pink};

	public BattlefieldManager(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
		battleFieldWidth = myrobot.getBattleFieldWidth();
		battleFieldHeight = myrobot.getBattleFieldHeight();
		fieldRect   = new Rectangle2D.Double(0,0,battleFieldWidth,battleFieldHeight);
		inFieldRect = new Rectangle2D.Double(2*BOT_WIDTH,2*BOT_WIDTH,battleFieldWidth - 4.0 * BOT_WIDTH,battleFieldHeight - 4.0 * BOT_WIDTH);
		vbFieldRect = new Rectangle2D.Double(-2*BOT_WIDTH,-2*BOT_WIDTH,battleFieldWidth + 4.0 * BOT_WIDTH,battleFieldHeight + 4.0 * BOT_WIDTH);
		arenaCenter = new Point2D.Double(battleFieldWidth / 2.0, battleFieldHeight / 2.0);
		
		int triangleH = (int)(battleFieldHeight / 3.0);
		int triangleW = (int)(battleFieldWidth  / 3.0);

		Rectangle2D.Double []tmp = new Rectangle2D.Double[4];
		tmp[DynaBotConstants.BOTTOMLEFT_CORNER]   = new Rectangle2D.Double(3 * BOT_WIDTH,3 * BOT_WIDTH, 
																battleFieldWidth / 6.0 , battleFieldHeight / 6.0 );
		tmp[DynaBotConstants.BOTTOMRIGHT_CORNER]  = new Rectangle2D.Double(2 * battleFieldWidth / 3.0 - 3 * BOT_WIDTH,3 * BOT_WIDTH, 
																battleFieldWidth / 6.0 , battleFieldHeight / 6.0 );
		tmp[DynaBotConstants.TOPRIGHT_CORNER]     = new Rectangle2D.Double(2 * battleFieldWidth / 3.0 - 3 * BOT_WIDTH, 2.0 * battleFieldHeight / 3.0 - 3 * BOT_WIDTH, 
																battleFieldWidth / 6.0 , battleFieldHeight / 6.0  );
		tmp[DynaBotConstants.TOPLEFT_CORNER]      = new Rectangle2D.Double(3 * BOT_WIDTH, 2.0 * battleFieldHeight / 3.0 - 3 * BOT_WIDTH, 
																battleFieldWidth / 6.0 , battleFieldHeight / 6.0 );																
																				
		cornerAreaCenters = new Point2D.Double[4];
		cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER]   = new Point2D.Double(3 * BOT_WIDTH,3 * BOT_WIDTH); 
		cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER]  = new Point2D.Double( battleFieldWidth - 3 * BOT_WIDTH,3 * BOT_WIDTH);
		cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER]     = new Point2D.Double( battleFieldWidth - 3 * BOT_WIDTH, battleFieldHeight - 3 * BOT_WIDTH); 
		cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER]      = new Point2D.Double(3 * BOT_WIDTH, battleFieldHeight - 3 * BOT_WIDTH);
																				
		cornerAreas = new Polygon[4];
		cornerAreas[DynaBotConstants.BOTTOMLEFT_CORNER]   = new Polygon();
		cornerAreas[DynaBotConstants.BOTTOMLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getY());
		cornerAreas[DynaBotConstants.BOTTOMLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getX() + triangleW,
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getY());
		cornerAreas[DynaBotConstants.BOTTOMLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getY() + triangleH);

		cornerAreas[DynaBotConstants.BOTTOMRIGHT_CORNER]  = new Polygon();
		cornerAreas[DynaBotConstants.BOTTOMRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getY());
		cornerAreas[DynaBotConstants.BOTTOMRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getX() - triangleW,
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getY());
		cornerAreas[DynaBotConstants.BOTTOMRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getY() + triangleH);
																		
		cornerAreas[DynaBotConstants.TOPRIGHT_CORNER]     = new Polygon();
		cornerAreas[DynaBotConstants.TOPRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getY());
		cornerAreas[DynaBotConstants.TOPRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getX() - triangleW,
																(int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getY());
		cornerAreas[DynaBotConstants.TOPRIGHT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getY() - triangleH);
																		
		cornerAreas[DynaBotConstants.TOPLEFT_CORNER]      = new Polygon();
		cornerAreas[DynaBotConstants.TOPLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getY());
		cornerAreas[DynaBotConstants.TOPLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getX() + triangleW,
																(int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getY());
		cornerAreas[DynaBotConstants.TOPLEFT_CORNER].addPoint((int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getX(),
																(int)cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getY() - triangleH);
																
		cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER] = new Point2D.Double(cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getX() + battleFieldWidth / 12,
																					cornerAreaCenters[DynaBotConstants.BOTTOMLEFT_CORNER].getY() + battleFieldHeight / 12);
		cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER] = new Point2D.Double(cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getX() - battleFieldWidth / 12,
																					cornerAreaCenters[DynaBotConstants.BOTTOMRIGHT_CORNER].getY() + battleFieldHeight / 12);
		cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER] = new Point2D.Double(cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getX() + battleFieldWidth / 12,
																					cornerAreaCenters[DynaBotConstants.TOPLEFT_CORNER].getY() - battleFieldHeight / 12);
		cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER] = new Point2D.Double(cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getX() - battleFieldWidth / 12,
																					cornerAreaCenters[DynaBotConstants.TOPRIGHT_CORNER].getY() - battleFieldHeight / 12);
																																																																																																						
	}

	/**
	 * what to do before each battle
	 */
	public boolean isPointInTheInField(Point2D.Double p) {
		return inFieldRect.contains(p);
	}

	/**
	 * what to do before each battle
	 */
	public void reset() {
		activeBulletsFired = new ArrayList();
		enemyBulletsFired  = new ArrayList();
		virtualBulletsFired = new ArrayList();
		myrobot.location = new Point2D.Double(0,0);
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
		// Always set the robot's location
		myrobot.lastLocation = new Point2D.Double(myrobot.location.getX(), myrobot.location.getY());
		myrobot.location = new Point2D.Double(myrobot.getX(), myrobot.getY());

		Enumeration en = myrobot.theEnemyManager.enemyList.elements();
		while(en.hasMoreElements()) {
			Enemy e = (Enemy)en.nextElement();
			e.enemyWaves = updateEnemyWaves(e.enemyWaves, myrobot.getTime(), myrobot.location);
		}
		
		myrobot.theGunManager.myWaves = updateWaves(myrobot.theGunManager.myWaves, myrobot.getTime(), 
													myrobot.theEnemyManager.enemyList, myrobot);
		updateVirualBullets();
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onBulletHit(BulletHitEvent e) {
		Bullet b = e.getBullet();
		removeActiveBulletsFired(b);
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		Bullet b = e.getBullet();
		removeActiveBulletsFired(b);
		
		// Remove wave...
		Point2D.Double impactLocation = new Point2D.Double(b.getX(), b.getY());
		EnemyWave ew = getClosestSurfableWave(impactLocation);
		if(ew != null) {
			Enemy enemy = (Enemy)myrobot.theEnemyManager.enemyList.get(ew.enemyName);
			enemy.enemyWaves.remove(ew);
			//myrobot.out.println("BulletHitBullet - removed wave from " + ew.enemyName);
		} else {
			//myrobot.out.println("BulletHitBullet - no wave found near impact location");
		}
	}

	public void onBulletMissed(BulletMissedEvent e) {
		Bullet b = e.getBullet();
		removeActiveBulletsFired(b);
	}

	protected void removeActiveBulletsFired(Bullet b) {
		AdvancedBullet ab = getAdvancedBulletFromBullet(b);
		if(ab != null) {
			activeBulletsFired.remove(activeBulletsFired);
		}
	}

	public void onDeath(DeathEvent e) {
	}

	public void onHitRobot(HitRobotEvent e) {
	}

    public void onPaint(java.awt.Graphics2D g) {
		/*
		g.setColor(Color.red);
		Enumeration en = myrobot.theEnemyManager.enemyList.elements();
		while(en.hasMoreElements()) {
			Enemy e = (Enemy)en.nextElement();
			//myrobot.out.println("painting waves from " + e.name + " has " + e.enemyWaves.size());
						
			for(int i = 0; i < e.enemyWaves.size(); i++){
				EnemyWave w = (EnemyWave)(e.enemyWaves.get(i));
				int radius = (int)w.distanceTraveled;

	            Point2D.Double center = w.fireLocation;
    	        if(radius - 40 < center.distance(myrobot.location)) {
					g.drawOval((int)(center.x - radius ), (int)(center.y - radius), radius*2, radius*2);
				}
			}
		}
		
		g.setColor(Color.green);
		for(int i = 0; i < myrobot.theGunManager.myWaves.size(); i++){
			EnemyWave w = (EnemyWave)(myrobot.theGunManager.myWaves.get(i));
			int radius = (int)w.distanceTraveled;
            Point2D.Double center = w.fireLocation;
			g.drawOval((int)(center.x - radius ), (int)(center.y - radius), radius*2, radius*2);
		}
		
		g.setColor(Color.red);
		g.draw(inFieldRect);
		g.setColor(Color.blue);
		for(int i=0;i<4;i++) {
			g.draw(cornerAreas[i]);
			g.fillOval((int)cornerAreaCenters[i].getX(), (int)cornerAreaCenters[i].getY(), 10, 10);
		}
		*/
		// Virtual bullets
		for(int i=0;i<virtualBulletsFired.size();i++) {
			VirtualBullet vb = (VirtualBullet)virtualBulletsFired.get(i);
			if(vb.gunID == DynaBotConstants.BEEGUN) {
				g.setColor(vGunColor[vb.gunID]);
				g.drawOval((int)vb.currentLocation.getX()-3, (int)vb.currentLocation.getY()-3, 6, 6);
				g.drawString("" + vb.gunID, (int)vb.currentLocation.getX(), (int)vb.currentLocation.getY()-10);
				int prevX = (int)vb.prevLocation.getX();
				int prevY = (int)vb.prevLocation.getY();
				g.drawLine((int)vb.currentLocation.getX(), (int)vb.currentLocation.getY(), prevX, prevY);
			}
		}
		
	}


	public void onRobotDeath(RobotDeathEvent e) {
	}

	public void onWin(WinEvent e) {
	}

	/************************************************************************************************************
	 *                                EnemyWave maintainence                                                    *
	 ***********************************************************************************************************/
    public static ArrayList updateEnemyWaves(ArrayList waveList, double currentTime, Point2D.Double targetPos) {
		ArrayList toRemove = new ArrayList();
		//myrobot.out.println("Updating enemy waves: " + waveList.size());
        for (int x = 0; x < waveList.size(); x++) {
            EnemyWave ew = (EnemyWave)waveList.get(x);

            ew.distanceTraveled = (currentTime - ew.fireTime) * ew.bulletVelocity;
			if (ew.distanceTraveled < targetPos.distance(ew.fireLocation) &&
					   ew.distanceTraveled + ew.bulletVelocity >= targetPos.distance(ew.fireLocation)) {
				// Wave hit an enemy
				//myrobot.out.println("Wave hit me from " + ew.enemyName);
				myrobot.theMoveManager.enemyWaveHitMe(ew.enemyName, ew);
			}
						
            if (ew.distanceTraveled > targetPos.distance(ew.fireLocation) + 50) {
				toRemove.add(ew);
            }
        }

		for(int x=0;x<toRemove.size();x++) {
			EnemyWave ew = (EnemyWave)toRemove.get(x);
			waveList.remove(ew);
		}
		return waveList;
    }

	// Used to update my waves; will pass in a Hashtable of enemies
    public static ArrayList updateWaves(ArrayList waveList, double currentTime, Hashtable enemyList, AbstractDynaBot self) {
		ArrayList toRemove = new ArrayList();
		
        for (int x = 0; x < waveList.size(); x++) { 
            EnemyWave ew = (EnemyWave)waveList.get(x);

            ew.distanceTraveled = (currentTime - ew.fireTime) * ew.bulletVelocity;
			Enumeration en = enemyList.elements();
			Enemy e;
			boolean bRemoveWave = true;
			
			while(en.hasMoreElements()) {
				e = (Enemy)en.nextElement();
				Point2D.Double targetPos = e.location;
	            if (ew.distanceTraveled < targetPos.distance(ew.fireLocation) + 50) {
					bRemoveWave = false;  // Wave is still in front of this target
					//break;
				}
				if (ew.distanceTraveled < targetPos.distance(ew.fireLocation) &&
						   ew.distanceTraveled + ew.bulletVelocity >= targetPos.distance(ew.fireLocation)) {
					// Wave hit an enemy
					//myrobot.out.println("Wave hit " + e.name);
					myrobot.theEnemyManager.waveHitEnemy(e.name, ew);
				}
			}
            if (bRemoveWave) {
				//myrobot.out.println("Removing wave");
           	    toRemove.add(ew);
   	        }
        }

		for(int x=0;x<toRemove.size();x++) {
			EnemyWave ew = (EnemyWave)toRemove.get(x);
			waveList.remove(ew);
		}
	
		return waveList;
    }

    public EnemyWave getClosestSurfableWave(ArrayList theWaveList, Point2D.Double targetPos) {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < theWaveList.size(); x++) {
            EnemyWave ew = (EnemyWave)theWaveList.get(x);
            double distance = targetPos.distance(ew.fireLocation) - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }

    public EnemyWave getClosestSurfableWave(Point2D.Double targetPos) {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;
		if(targetPos == null) return null;
		
		Hashtable enemyList = myrobot.theEnemyManager.enemyList;
		Enumeration en = enemyList.elements();
		Enemy e;

		while(en.hasMoreElements()) {
	    	e = (Enemy)en.nextElement();
	        for (int x = 0; x < e.enemyWaves.size(); x++) {
    	        EnemyWave ew = (EnemyWave)e.enemyWaves.get(x);
        	    double distance = targetPos.distance(ew.fireLocation) - ew.distanceTraveled;

            	if (distance > ew.bulletVelocity && distance < closestDistance) {
                	surfWave = ew;
	                closestDistance = distance;
    	        }
        	}
		}
			
        return surfWave;
    }

    public EnemyWave getNextClosestSurfableWave(Point2D.Double targetPos, EnemyWave excludeWave) {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;
		if(targetPos == null) return null;
		
		Hashtable enemyList = myrobot.theEnemyManager.enemyList;
		Enumeration en = enemyList.elements();
		Enemy e;

		while(en.hasMoreElements()) {
	    	e = (Enemy)en.nextElement();
	        for (int x = 0; x < e.enemyWaves.size(); x++) {
    	        EnemyWave ew = (EnemyWave)e.enemyWaves.get(x);
				if(ew != excludeWave) {
	        	    double distance = targetPos.distance(ew.fireLocation) - ew.distanceTraveled;

    	        	if (distance > ew.bulletVelocity && distance < closestDistance) {
        	        	surfWave = ew;
	        	        closestDistance = distance;
    	        	}
				}
        	}
		}
			
        return surfWave;
    }
		
	/************************************************************************************************************
	 *                                Bullet maintainence                                                       *
	 ***********************************************************************************************************/
	public void enemyFired(double shotPower, String enemyName, Point2D.Double enemyShotFromLoc) {
		// TODO - Create an AdvancedBullet for enemyBulletsFired
		
		// Then, pass it over to the movement manager
		myrobot.theMoveManager.enemyFired(shotPower, enemyName, enemyShotFromLoc);
	}

	public void doFireGun(double shotPower, AdvancedBullet ab) {
		activeBulletsFired.add(ab);
	}
	
	public AdvancedBullet getAdvancedBulletFromBullet(Bullet b) {
		for(int i=0;i<activeBulletsFired.size();i++) {
			AdvancedBullet ab = (AdvancedBullet)activeBulletsFired.get(i);
			if(ab.b == b) return ab;
		}
		return null;  // Did not find the Bullet
	}

	protected void updateVirualBullets() {
		ArrayList vbToRemove = new ArrayList();
		
		for(int i=0;i<virtualBulletsFired.size();i++) {
			VirtualBullet vb = (VirtualBullet)virtualBulletsFired.get(i);
			//myrobot.out.println("Updating " + (int)vb.currentLocation.getX() + "," + (int)vb.currentLocation.getY() + " for " + vb.enemyName + " at " + myrobot.getTime());
			vb.advanceBullet((int)myrobot.getTime());
			if(vb.hitTarget(myrobot)) {
				//myrobot.out.print("BM: VirtualBullet hit " + vb.enemyName + " with gun " + vb.gunID);
				//myrobot.out.println(" ;removing VirtualBullet ");
				myrobot.theEnemyManager.recordVirtualHit(vb.enemyName, vb.firedAtDistance, vb.gunID);
				//i--;
				//virtualBulletsFired.remove(vb);				
				vbToRemove.add(vb);
			}
			if(!fieldRect.contains(vb.currentLocation)) {
				myrobot.theEnemyManager.recordVirtualMiss(vb.enemyName, vb.firedAtDistance, vb.gunID);
				//myrobot.out.println("BM: removing VirtualBullet " + vb.enemyName + " for gun " + vb.gunID);
				vbToRemove.add(vb);
			}
		}
	
		for(int i=0;i<vbToRemove.size();i++) {
			VirtualBullet vb = (VirtualBullet)vbToRemove.get(i);			
			virtualBulletsFired.remove(vb);
		}
	}

	/************************************************************************************************************
	 *                                Wall smoothing functions                                                  *
	 ***********************************************************************************************************/
	// CREDIT: Iterative WallSmoothing by Kawigi
    //   - return absolute angle to move at after account for WallSmoothing
    // robowiki.net?WallSmoothing
	public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
		//if(shouldSmooth(botLocation, angle, orientation)) {
    	    while (!inFieldRect.contains(MyUtils.project(botLocation, angle, DynaBotConstants.WALL_STICK))) {
        	    angle += orientation*0.05;
	        }
			
			//angle = smooth(angle, orientation);
		//}
        return angle;
    }

	public void translateInsideField(Point2D.Double point, double margin) {
		point.setLocation(Math.max(margin, Math.min(battleFieldWidth  - margin, point.getX())),
						  Math.max(margin, Math.min(battleFieldHeight - margin, point.getY())));
	}
}
