package ph.musketeer;

import java.awt.geom.*;

public class StatsManager {
    
    // velocity, acceleration, acceleration timer, direction timer, wall index, distanceguess factors
    static int[][][][][][][] guessFactors=new int[3][3][4][4][3][21][27];
    
    static int[] distances=new int[21];
    
    /** Creates a new instance of StatsManager */
    public StatsManager() {
    }
    
    public void distanceHit(double distance) {
        distances[distanceIndex(distance)]++;
    }
    
    public int[] getStatsArray(Musketeer m) {
        return guessFactors
        [velocityIndex(m.enemyVelocity)]
        [accelerationIndex(m.enemyAcceleration)]
        [accelerationTimerIndex(m.getTime(), m.accelerationTimer, m.enemyDistance, m.firePower)]
        [directionTimerIndex(m.getTime(), m.directionTimer, m.enemyDistance, m.firePower)]
        [wallIndex(m.enemyLocation, m.enemyDistance, m.enemyHeading, m.enemyVelocity, m.firePower, m.getBattleFieldWidth(), m.getBattleFieldHeight())]
        [distanceIndex(m.enemyDistance)];
    }
    
    public int[] getShootArray(Musketeer m) {
        int gf[] = new int[27];
        int stats[][] = guessFactors
        [velocityIndex(m.enemyVelocity)]
        [accelerationIndex(m.enemyAcceleration)]
        [accelerationTimerIndex(m.getTime(), m.accelerationTimer, m.enemyDistance, m.firePower)]
        [directionTimerIndex(m.getTime(), m.directionTimer, m.enemyDistance, m.firePower)]
        [wallIndex(m.enemyLocation, m.enemyDistance, m.enemyHeading, m.enemyVelocity, m.firePower, m.getBattleFieldWidth(), m.getBattleFieldHeight())];
        
        int fIndex = distanceIndex(m.enemyDistance);
        
        int startIndex, endIndex;
        startIndex = fIndex - 2;
        while (startIndex < 0) startIndex++;
        endIndex = fIndex + 2;
        while (endIndex > 20) endIndex--;
        for (int i = startIndex; i <= endIndex; i++) {
            for (int j = 0; j < 27; j++) {
                if(Math.abs(bestIndex(stats[fIndex])-bestIndex(stats[i]))<=2)
                    gf[j] += stats[i][j] / (Math.abs(fIndex - i) + 1);
            }
        }
        
        return gf;
    }
    
    private int bestIndex(int[] t) {
        int bestindex = (t.length-1)/2;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<t.length; i++)
            if (t[bestindex] < t[i])
                bestindex = i;
        
        return bestindex;
    }
    
    private int distanceIndex(double distance) {
        return Math.min(20,(int)distance/50);
    }
    
    private int velocityIndex(double enemyVelocity) {
        double v;
        if ((v=Math.abs(enemyVelocity)) < 2) {
            return 0;
        }
        if (v < 6) {
            return 1;
        }
        return 2;
    }
    
    private int accelerationIndex(double enemyAcceleration) {
        if(enemyAcceleration<0)
            return 0;
        else if(enemyAcceleration>0)
            return 1;
        else
            return 2;
    }
    
    private int accelerationTimerIndex(long ctime, double accelerationTimer, double enemyDistance, double firePower) {
        double time=(ctime-accelerationTimer)/(enemyDistance/util.getBulletSpeed(firePower));
        if(time<0.1)
            return 0;
        else if(time<0.3)
            return 1;
        else if(time<1)
            return 2;
        else
            return 3;
    }
    
    private int directionTimerIndex(long ctime, double directionTimer, double enemyDistance, double firePower) {
        double time=(ctime-directionTimer)/(enemyDistance/util.getBulletSpeed(firePower));
        if(time<0.1)
            return 0;
        else if(time<0.3)
            return 1;
        else if(time<1)
            return 2;
        else
            return 3;
    }
    
    private int wallIndex(Point2D enemyLocation, double enemyDistance, double enemyHeading, double enemyVelocity, double firePower, double bfw, double bfh) {
        Point2D nextEnemyLocation = util.vectorToLocation(enemyHeading,
        (enemyDistance / util.getBulletSpeed(firePower)) * enemyVelocity, enemyLocation);
        if (!util.fieldRectangle(bfw, bfh, 18).contains(nextEnemyLocation)) {
            return 2;
        }
        if (!util.fieldRectangle(bfw, bfh, 36).contains(nextEnemyLocation)) {
            return 1;
        }
        return 0;
    }
    
}
