/*
 * Created on 2004-10-25
 */
package tide.pear.statistic;

import tide.util.Utils;


/**
 * @author iiley(Chen Jing)
 */
public class BasicHitStatist extends BasicStatist {
	private int hitIndex = -1;
	private float[] temp; 
	/**
	 * @param size
	 * @param count
	 */
	public BasicHitStatist(int size, float weigh) {
		super(size, weigh);
		temp = new float[size];
	}
	/**
	 * @param size
	 * @param count
	 * @param weight
	 */
	public BasicHitStatist(int size, float weigh, float weight) {
		super(size, weigh, weight);
		temp = new float[size];
	}
	
	/* (non-Javadoc)
	 * @see tide.util.Statist#rate(int)
	 */
	public void rate(int index) {
	}
	
	
	
	
	/* (non-Javadoc)
	 * @see tide.util.Statist#rateToHighest(int)
	 */
	public void rateHit(int index){
		rateHitVersion1(index);
		//rateHitVersion2(index);
	}
	
	

	public void rateHitVersion2(int index) {
		if(index<0 || index >= factors.length){
			return;
		}
		//adjust temp [0,1] from factors
		float maxFactor = factors[Utils.maxValueIndex(factors)];
		if(maxFactor > 0f){
			for(int i=0; i<size; i++){
				temp[i] = factors[i]/maxFactor;
			}
			int lIndex = index - 1;
			int rIndex = index + 1;
			if(lIndex < 0){
				lIndex = rIndex;
			}
			if(rIndex >= size){
				rIndex = lIndex;
			}
			float avFactor = getAvFactor(temp, index)/2f;
			float turn = 4f/(1f+7f*avFactor);
			this.weigh *= turn;
		}
		
		for(int i=0; i<factors.length; i++){
			factors[i]*=(1f - weight);
    	}
		factors[index] += weight;
	}
	
	private float getAvFactor(float[] fs, int index){
		float factor = 0;
		for(int i=0; i<fs.length; i++){
			factor += fs[i]/((float)Math.pow(2, Math.abs(index - i)));
		}
		return factor;
	}

	public void rateHitVersion1(int index) {
		if(index<0 || index >= factors.length){
			return;
		}
		for(int i=0; i<factors.length; i++){
			factors[i]*=(1f - weight);
    	}
		factors[index] += weight;//*Math.pow((2f*size)/(size+1f*Math.pow(hitIndex - index, 2)), 1);
		
		if(hitIndex >= 0){
			//double weighChange = Math.pow((2f*size)/(size+1f*Math.pow(hitIndex - index, 2)), 1);
			double weighChange = (2f*size)/(size+7f*Math.abs(hitIndex - index));
			this.weigh /= (float)weighChange;
		}
		hitIndex = index;
	}
}
