package DTF.modules;

//todo mutation

import java.util.Arrays;

import DTF.Util;

public class GenePool {
	private Genotype[] population;
	private int size;
	
	public GenePool(int size, double[] min, double[] max) {
		while(size%4>0) size++; //make size multiple of 4
		
		this.size=size;
		population=new Genotype[size];
	
		int len=min.length;
		
		double[][] initial=new double[len][];
		
		//create shuffled values with equal distribution between each min/max (slightly better than pure random)
		for(int i=0;i<len;i++) {
			double[] a=new double[size];
			initial[i]=a;
			for(int j=0;j<size;j++) {
				double b=(double)j/(double)(size-1);
				a[j]=min[i]*(1.0-b)+max[i]*b;
			}
			Util.shuffle(a);
		}
		// create gene pool from shuffled values
		for(int j=0;j<size;j++) {
			double[] a=new double[len];
			for(int i=0;i<len;i++) {
				a[i]=initial[i][j];
			}
			population[j]=new Genotype(a);
		}
	}
	

	public double[] getCurrent(int round) {
		return population[round%size].values;
	}
	
	public void scoreCurrent(int round, double score) {
		int i=round%size;
		
		population[i].addScore(score);
		
		if(i==size-1) { //if this is the last member (everyone has been scored), then evolve
			evolve();
		}
	}
	
	private void evolve() {
		Arrays.sort(population);
		//lowest scored are now at top of the array

		int half=size/2;
		Genotype[] survivors=new Genotype[half];
		for(int i=0;i<half;i++) {
			survivors[i]=population[half+i];
		}
		
		Util.println("Survivors");
		//print top rated at top because robocode will often cut off the bottom
		for(int i=half-1;i>=0;i--) {
			Util.println(survivors[i].toString());
		}
		
		Util.shuffle(survivors);
		
		//replace losers with crossbreeding of survivors
		for(int i=0;i<half;i++) {
			population[i]=new Genotype(survivors[i].values);
			if(i%2>0) population[i].crossOver(population[i-1]);
		}
		
		//shuffle whole population to avoid order bias
		Util.shuffle(population);
	}
	
}
