/*
 * VirtualBlotBullet - utility class
 * Copyright (C) 2002  Joachim Hofer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * You can contact the author via email (qohnil@johoop.de) or write to
 * Joachim Hofer, Feldstr. 12, D-91052 Erlangen, Germany.
 */

package qohnil.blot;

import robocode.AdvancedRobot;

import java.io.Serializable;

import qohnil.util.Coords;

public class VirtualBlotBullet extends VirtualBullet implements Serializable {
    AdvancedRobot bot;
    int firingMode;

    public static final int DIRECT_FIRE = 0;
    public static final int LINEAR_FIRE = 1;
    public static final int CIRCULAR_FIRE = 2;
    public static final int AVG_LINEAR_FIRE = 3;
    public static final int AVG_CIRCULAR_FIRE = 4;
    public static final int AVG_ABS_LINEAR_FIRE = 5;
    public static final int AVG_ABS_CIRCULAR_FIRE = 6;
    public static final int INVERSE_LINEAR_FIRE = 7;
    public static final int INVERSE_CIRCULAR_FIRE = 8;

    public static final int NUM_FIRING_MODES = 9;

    /* unused */
    public static final int PATTERN_MATCHING_FIRE = 9;


    public VirtualBlotBullet(int firingMode, double angle, double firePower,
                         AdvancedRobot bot) {

        super(angle, firePower, new Coords(bot.getX(), bot.getY()), bot.getTime());

        this.firingMode = firingMode;
        this.bot = bot;
    }

    public int getFiringMode() { return firingMode; }
}
