/*
 * Logger - Utility class for debug logging.
 * Copyright (C) 2002  Joachim Hofer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * You can contact the author via email (qohnil@johoop.de) or write to
 * Joachim Hofer, Feldstr. 12, D-91052 Erlangen, Germany.
 */
package qohnil.util;

import robocode.RobocodeFileOutputStream;
import robocode.AdvancedRobot;

import java.io.PrintWriter;
import java.io.IOException;
import java.io.File;
import java.io.FileNotFoundException;

import qohnil.xbot.IXBot;

public class Logger {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    public static final int NO_LOGGING = 99;

    static PrintWriter logPW = null;
    static int debugLevel = NO_LOGGING;
    static AdvancedRobot bot = null;
    static int battleNr = 0;

    public static void init(String fileName, int debugLevel, AdvancedRobot bot) {
        Logger.debugLevel = debugLevel;
        Logger.bot = bot;
        battleNr++;

        if (logPW != null) {
            // already initialized
            return;
        }
        try {
            File logFile = bot.getDataFile(fileName);
            logPW = new PrintWriter(
                    new RobocodeFileOutputStream(logFile));
        } catch(IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void print(int debugLevel, String str) {
        if (logPW == null) {
            System.out.println("FATAL: LOGGER NOT INITIALIZED!");
        }
        if (debugLevel >= Logger.debugLevel) {
            logPW.print(str);
            logPW.flush();
        }
    }

    public static void println(int debugLevel, String str) {
        if (logPW == null) {
            System.out.println("FATAL: LOGGER NOT INITIALIZED!");
        }
        if (debugLevel >= Logger.debugLevel) {
            logPW.println(battleNr + " (" + bot.getTime() + "): " + str);
            logPW.flush();
        }
    }

    public static void debug(String str) {
        println(DEBUG, "[DEBUG] " + str);
    }

    public static void info(String str) {
        println(INFO, "[INFO] " + str);
    }

    public static void warn(String str) {
        println(WARN, "[WARN] " + str);
    }

    public static void error(String str) {
        println(ERROR, "[ERROR] " + str);
    }

    public static void fatal(String str) {
        println(FATAL, "[FATAL] " + str);
    }
}
